/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.atom;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Constant;

public class PersistedAtomManager
extends AtomManager {
    protected final Set<RandomVariableAtom> persistedCache = new HashSet<RandomVariableAtom>();

    public PersistedAtomManager(Database db) {
        super(db);
        this.buildPersistedAtomCache();
    }

    private void buildPersistedAtomCache() {
        for (StandardPredicate predicate : this.db.getRegisteredPredicates()) {
            if (this.db.isClosed(predicate)) {
                this.db.getAllGroundAtoms(predicate);
                continue;
            }
            for (RandomVariableAtom atom : this.db.getAllGroundRandomVariableAtoms(predicate)) {
                this.persistedCache.add(atom);
            }
        }
    }

    @Override
    public GroundAtom getAtom(Predicate predicate, Constant ... arguments) {
        GroundAtom atom = this.db.getAtom(predicate, arguments);
        if (!(atom instanceof RandomVariableAtom)) {
            return atom;
        }
        RandomVariableAtom rvAtom = (RandomVariableAtom)atom;
        if (this.persistedCache.contains(rvAtom)) {
            return atom;
        }
        throw new PersistedAccessException(rvAtom);
    }

    public void commitPersistedAtoms() {
        this.db.commit(this.persistedCache);
    }

    public Set<RandomVariableAtom> getPersistedRVAtoms() {
        return Collections.unmodifiableSet(this.persistedCache);
    }

    protected void addToPersistedCache(Set<RandomVariableAtom> atoms) {
        this.persistedCache.addAll(atoms);
    }

    public static class PersistedAccessException
    extends IllegalArgumentException {
        public RandomVariableAtom atom;

        public PersistedAccessException(RandomVariableAtom atom) {
            super("Can only call getAtom() on persisted RandomVariableAtoms using a PersistedAtomManager. Cannot access " + atom);
            this.atom = atom;
        }
    }
}

