/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.loading;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Inserter {
    private static final Logger log = LoggerFactory.getLogger(Inserter.class);
    public static final String DEFAULT_DELIMITER = "\t";
    private final int arity;

    public Inserter(int arity) {
        this.arity = arity;
    }

    public void insert(Object ... data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Attempted to insert empty data.");
        }
        ArrayList<List<Object>> newData = new ArrayList<List<Object>>(1);
        newData.add(Arrays.asList(data));
        this.insertAll(newData);
    }

    public void insertValue(double value, Object ... data) {
        if (data == null || data.length == 0) {
            throw new IllegalArgumentException("Attempted to insert empty data.");
        }
        if (value < 0.0 || value > 1.0) {
            throw new IllegalArgumentException("Invalid truth value: " + value + ". Must be between 0 and 1 inclusive.");
        }
        ArrayList<List<Object>> newData = new ArrayList<List<Object>>(1);
        newData.add(Arrays.asList(data));
        ArrayList<Double> newValue = new ArrayList<Double>(1);
        newValue.add(value);
        this.insertAllValues(newValue, newData);
    }

    public void loadDelimitedData(String path) {
        this.loadDelimitedData(path, DEFAULT_DELIMITER);
    }

    public void loadDelimitedData(String path, String delimiter) {
        if (this.supportsBulkCopy()) {
            this.bulkCopy(path, delimiter, false);
            return;
        }
        List<List<Object>> data = Inserter.loadDelimitedDataInternal(path, delimiter);
        this.insertAll(data);
    }

    public void loadDelimitedDataTruth(String path) {
        this.loadDelimitedDataTruth(path, DEFAULT_DELIMITER);
    }

    public void loadDelimitedDataTruth(String path, String delimiter) {
        if (this.supportsBulkCopy()) {
            this.bulkCopy(path, delimiter, true);
            return;
        }
        List<List<Object>> data = Inserter.loadDelimitedDataInternal(path, delimiter);
        ArrayList<Double> values = new ArrayList<Double>(data.size());
        for (int i = 0; i < data.size(); ++i) {
            double truth;
            List<Object> row = data.get(i);
            try {
                truth = Double.parseDouble((String)row.get(row.size() - 1));
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Could not read truth value for row " + (i + 1) + ": " + row.get(row.size() - 1), ex);
            }
            if (truth < 0.0 || truth > 1.0) {
                throw new IllegalArgumentException("Illegal truth value encountered on row " + (i + 1) + ": " + truth);
            }
            data.set(i, row.subList(0, row.size() - 1));
            values.add(truth);
        }
        this.insertAllValues(values, data);
    }

    public void loadDelimitedDataAutomatic(String path) {
        this.loadDelimitedDataAutomatic(path, DEFAULT_DELIMITER);
    }

    public void loadDelimitedDataAutomatic(String path, String delimiter) {
        boolean hasTruth = false;
        try (BufferedReader reader = new BufferedReader(new FileReader(path));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                String[] parts = line.split(delimiter);
                hasTruth = parts.length > this.arity;
                break;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to parse delimited file.", ex);
        }
        if (hasTruth) {
            this.loadDelimitedDataTruth(path, delimiter);
        } else {
            this.loadDelimitedData(path, delimiter);
        }
    }

    private static List<List<Object>> loadDelimitedDataInternal(String path, String delimiter) {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>();
        try (BufferedReader reader = new BufferedReader(new FileReader(path));){
            String line = null;
            int lineNumber = 0;
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if ((line = line.trim()).isEmpty()) continue;
                Object[] data = line.split(delimiter);
                rows.add(Arrays.asList(data));
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to parse delimited file.", ex);
        }
        return rows;
    }

    public abstract boolean supportsBulkCopy();

    public abstract void bulkCopy(String var1, String var2, boolean var3);

    public abstract void insertAll(List<List<Object>> var1);

    public abstract void insertAllValues(List<Double> var1, List<List<Object>> var2);
}

