/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.linqs.psl.database.DatabaseQuery;
import org.linqs.psl.database.rdbms.RDBMSDataStore;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.formula.Conjunction;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.predicate.ExternalFunctionalPredicate;
import org.linqs.psl.model.predicate.SpecialPredicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.model.term.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptimalCover {
    private static final Logger log = LoggerFactory.getLogger(OptimalCover.class);
    public static final double BLOCK_ADVANTAGE = 100.0;
    public static final double JOIN_PENALTY = 2.0;
    public static final boolean ALWAYS_INCLUDE_BLOCKS = true;

    private OptimalCover() {
    }

    public static Formula computeOptimalCover(Formula baseFormula, RDBMSDataStore dataStore) {
        DatabaseQuery.validate(baseFormula);
        if (baseFormula instanceof Atom) {
            return baseFormula;
        }
        Set<Atom> formulaAtoms = baseFormula.getAtoms(new HashSet<Atom>());
        ArrayList<Formula> usedAtoms = new ArrayList<Formula>();
        OptimalCover.filterBaseAtoms(formulaAtoms, usedAtoms);
        Map<Variable, Set<Atom>> variableUsages = OptimalCover.getVariableUsages(formulaAtoms, usedAtoms);
        boolean foundBlock = false;
        foundBlock = OptimalCover.includeBlocks(usedAtoms, variableUsages);
        OptimalCover.computeOptimalCover(usedAtoms, variableUsages, foundBlock, dataStore);
        Formula optimal = null;
        optimal = usedAtoms.size() == 1 ? (Formula)usedAtoms.get(0) : new Conjunction(usedAtoms.toArray(new Formula[0]));
        log.debug("Computed optimal cover for [{}]: [{}].", (Object)baseFormula, (Object)optimal);
        return optimal;
    }

    private static void computeOptimalCover(List<Formula> atoms, Map<Variable, Set<Atom>> variableUsages, boolean foundBlock, RDBMSDataStore dataStore) {
        if (variableUsages.size() == 0) {
            return;
        }
        if (foundBlock) {
            OptimalCover.partialBlockingCover(atoms, variableUsages, dataStore);
        } else {
            OptimalCover.noBlockingCover(atoms, variableUsages, dataStore);
        }
    }

    private static void partialBlockingCover(List<Formula> usedAtoms, Map<Variable, Set<Atom>> variableUsages, RDBMSDataStore dataStore) {
        int count;
        StandardPredicate predicate;
        int bestCount;
        Atom bestAtom;
        Variable variable;
        HashSet<Variable> coveredVariables = new HashSet<Variable>();
        for (Formula atom : usedAtoms) {
            for (Term term : ((Atom)atom).getArguments()) {
                if (!(term instanceof Variable)) continue;
                coveredVariables.add((Variable)term);
            }
        }
        boolean done = false;
        while (!done) {
            done = true;
            variable = variableUsages.keySet().iterator().next();
            bestAtom = null;
            bestCount = -1;
            block3: for (Atom atom : variableUsages.get(variable)) {
                Term[] arr$ = atom.getArguments();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Term term = arr$[i$];
                    if (!(term instanceof Variable) || !coveredVariables.contains((Variable)term)) continue;
                    predicate = (StandardPredicate)atom.getPredicate();
                    count = dataStore.getPredicateRowCount(predicate);
                    if (bestAtom != null && count >= bestCount) continue;
                    bestAtom = atom;
                    bestCount = count;
                    continue block3;
                }
            }
            if (bestAtom == null) continue;
            usedAtoms.add(bestAtom);
            for (Term term : bestAtom.getArguments()) {
                if (!(term instanceof Variable)) continue;
                coveredVariables.add((Variable)term);
                variableUsages.remove((Variable)term);
            }
        }
        while (variableUsages.size() > 0) {
            variable = variableUsages.keySet().iterator().next();
            bestAtom = null;
            bestCount = -1;
            block7: for (Atom atom : variableUsages.get(variable)) {
                for (Term term : atom.getArguments()) {
                    if (!(term instanceof Variable)) continue;
                    predicate = (StandardPredicate)atom.getPredicate();
                    count = dataStore.getPredicateRowCount(predicate);
                    if (bestAtom != null && count >= bestCount) continue;
                    bestAtom = atom;
                    bestCount = count;
                    continue block7;
                }
            }
            if (bestAtom == null) continue;
            usedAtoms.add(bestAtom);
            for (Term term : bestAtom.getArguments()) {
                if (!(term instanceof Variable)) continue;
                coveredVariables.add((Variable)term);
                variableUsages.remove((Variable)term);
            }
        }
    }

    private static void noBlockingCover(List<Formula> usedAtoms, Map<Variable, Set<Atom>> variableUsages, RDBMSDataStore dataStore) {
        HashSet<Atom> cover = new HashSet<Atom>();
        for (Set<Atom> atoms : variableUsages.values()) {
            cover.addAll(atoms);
        }
        HashMap variableSets = new HashMap(cover.size());
        for (Atom atom : cover) {
            HashSet<Variable> variables = new HashSet<Variable>();
            for (Term term : atom.getArguments()) {
                if (!(term instanceof Variable)) continue;
                variables.add((Variable)term);
            }
            variableSets.put(atom, variables);
        }
        HashSet<Atom> toRemove = new HashSet<Atom>();
        for (Atom atom1 : cover) {
            for (Atom atom2 : cover) {
                if (atom1 == atom2) continue;
                Set set1 = (Set)variableSets.get(atom1);
                Set set2 = (Set)variableSets.get(atom2);
                if (set1.size() <= set2.size() || !set1.containsAll(set2)) continue;
                toRemove.add(atom2);
            }
        }
        cover.removeAll(toRemove);
        variableUsages.clear();
        usedAtoms.addAll(cover);
    }

    private static void greedyCover(List<Formula> atoms, Map<Variable, Set<Atom>> variableUsages, RDBMSDataStore dataStore) {
        HashMap<Atom, Integer> satisfiableVariablesMap = new HashMap<Atom, Integer>();
        HashSet blockedVariables = new HashSet();
        while (variableUsages.size() != 0) {
            Variable variable = null;
            if (blockedVariables.size() != 0) {
                variable = (Variable)blockedVariables.iterator().next();
                blockedVariables.remove(variable);
            } else {
                variable = variableUsages.keySet().iterator().next();
            }
            Set<Atom> potentialAtoms = variableUsages.get(variable);
            Atom chosenAtom = null;
            if (potentialAtoms.size() == 1) {
                chosenAtom = potentialAtoms.iterator().next();
            } else {
                double bestCost = -1.0;
                Atom bestAtom = null;
                int maxSatisfiableVariables = 1;
                satisfiableVariablesMap.clear();
                for (Atom potentialAtom : potentialAtoms) {
                    int satisfiableVariables = 0;
                    for (Term term : potentialAtom.getArguments()) {
                        if (!(term instanceof Variable) || !variableUsages.containsKey((Variable)term)) continue;
                        ++satisfiableVariables;
                    }
                    satisfiableVariablesMap.put(potentialAtom, new Integer(satisfiableVariables));
                    if (satisfiableVariables <= maxSatisfiableVariables) continue;
                    maxSatisfiableVariables = satisfiableVariables;
                }
                for (Atom potentialAtom : potentialAtoms) {
                    StandardPredicate predicate = (StandardPredicate)potentialAtom.getPredicate();
                    double cost = dataStore.getPredicateRowCount(predicate);
                    if (predicate.isBlock()) {
                        cost /= 100.0;
                    }
                    cost *= Math.pow(2.0, maxSatisfiableVariables - (Integer)satisfiableVariablesMap.get(potentialAtom));
                    if (bestAtom != null && !(cost < bestCost)) continue;
                    bestAtom = potentialAtom;
                    bestCost = cost;
                }
                chosenAtom = bestAtom;
            }
            atoms.add(chosenAtom);
            for (Term term : chosenAtom.getArguments()) {
                if (!(term instanceof Variable)) continue;
                variableUsages.remove((Variable)term);
                blockedVariables.remove((Variable)term);
            }
            for (Set<Atom> atomUsage : variableUsages.values()) {
                atomUsage.remove(chosenAtom);
            }
        }
    }

    private static boolean includeBlocks(List<Formula> atoms, Map<Variable, Set<Atom>> variableUsages) {
        HashSet<Variable> toRemove = new HashSet<Variable>();
        HashSet<Atom> toAdd = new HashSet<Atom>();
        for (Map.Entry<Variable, Set<Atom>> entry : variableUsages.entrySet()) {
            for (Atom atom : entry.getValue()) {
                if (!((StandardPredicate)atom.getPredicate()).isBlock()) continue;
                toAdd.add(atom);
                for (Term term : atom.getArguments()) {
                    if (!(term instanceof Variable)) continue;
                    toRemove.add((Variable)term);
                }
            }
        }
        atoms.addAll(toAdd);
        for (Variable variable : toRemove) {
            variableUsages.remove(variable);
        }
        return toAdd.size() > 0;
    }

    private static void collectSingletonVariables(List<Formula> atoms, Map<Variable, Set<Atom>> variableUsages) {
        HashSet<Variable> satisfiedVariables = new HashSet<Variable>();
        boolean done = false;
        while (!done) {
            done = true;
            satisfiedVariables.clear();
            Atom usedAtom = null;
            for (Map.Entry<Variable, Set<Atom>> entry : variableUsages.entrySet()) {
                if (entry.getValue().size() != 1) continue;
                done = false;
                usedAtom = entry.getValue().iterator().next();
                atoms.add(usedAtom);
                for (Term term : usedAtom.getArguments()) {
                    if (!(term instanceof Variable)) continue;
                    satisfiedVariables.add((Variable)term);
                }
            }
            if (done) continue;
            for (Variable variable : satisfiedVariables) {
                variableUsages.remove(variable);
            }
            for (Set set : variableUsages.values()) {
                set.remove(usedAtom);
            }
        }
    }

    private static Map<Variable, Set<Atom>> getVariableUsages(Set<Atom> atoms, List<Formula> usedAtoms) {
        HashMap<Variable, Set<Atom>> usages = new HashMap<Variable, Set<Atom>>();
        for (Atom atom : atoms) {
            boolean hasVariables = false;
            for (Term term : atom.getArguments()) {
                if (!(term instanceof Variable)) continue;
                hasVariables = true;
                Variable variable = (Variable)term;
                if (!usages.containsKey(variable)) {
                    usages.put(variable, new HashSet());
                }
                ((Set)usages.get(variable)).add(atom);
            }
            if (hasVariables) continue;
            usedAtoms.add(atom);
        }
        return usages;
    }

    private static void filterBaseAtoms(Set<Atom> atoms, List<Formula> usedAtoms) {
        ArrayList<Atom> removeAtoms = new ArrayList<Atom>();
        for (Atom atom : atoms) {
            if (atom.getPredicate() instanceof ExternalFunctionalPredicate) {
                removeAtoms.add(atom);
                continue;
            }
            if (atom.getPredicate() instanceof SpecialPredicate) {
                removeAtoms.add(atom);
                usedAtoms.add(atom);
                continue;
            }
            if (atom.getPredicate() instanceof StandardPredicate) continue;
            throw new IllegalStateException("Unknown predicate type: " + atom.getPredicate().getClass().getName());
        }
        atoms.removeAll(removeAtoms);
    }
}

