/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.joda.time.DateTime;
import org.linqs.psl.database.DataStore;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.DatabaseQuery;
import org.linqs.psl.database.Partition;
import org.linqs.psl.database.ReadOnlyDatabase;
import org.linqs.psl.database.ResultList;
import org.linqs.psl.database.rdbms.Formula2SQL;
import org.linqs.psl.database.rdbms.PredicateInfo;
import org.linqs.psl.database.rdbms.RDBMSDataStore;
import org.linqs.psl.database.rdbms.RDBMSResultList;
import org.linqs.psl.model.atom.AtomCache;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.atom.QueryAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.predicate.FunctionalPredicate;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.model.term.DateAttribute;
import org.linqs.psl.model.term.DoubleAttribute;
import org.linqs.psl.model.term.IntegerAttribute;
import org.linqs.psl.model.term.LongAttribute;
import org.linqs.psl.model.term.StringAttribute;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.model.term.UniqueIntID;
import org.linqs.psl.model.term.UniqueStringID;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.model.term.VariableTypeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDBMSDatabase
implements Database {
    private static final Logger log = LoggerFactory.getLogger(RDBMSDatabase.class);
    private static final double DEFAULT_UNOBSERVED_VALUE = 0.0;
    private final RDBMSDataStore parentDataStore;
    private final Partition writePartition;
    private final int writeID;
    private final List<Partition> readPartitions;
    private final List<Integer> readIDs;
    private final Set<Predicate> closedPredicates;
    private final Map<Predicate, PredicateInfo> predicates;
    private final AtomCache cache;
    private ReadOnlyDatabase readOnlyDatabase;
    private boolean closed;

    public RDBMSDatabase(RDBMSDataStore parent, Partition write, Partition[] read, Map<Predicate, PredicateInfo> predicates, Set<StandardPredicate> closed) {
        this.parentDataStore = parent;
        this.writePartition = write;
        this.writeID = write.getID();
        this.readPartitions = Arrays.asList(read);
        this.readIDs = new ArrayList<Integer>(read.length);
        for (int i = 0; i < read.length; ++i) {
            this.readIDs.add(read[i].getID());
        }
        if (!this.readIDs.contains(this.writeID)) {
            this.readIDs.add(this.writeID);
        }
        this.predicates = new HashMap<Predicate, PredicateInfo>();
        for (Map.Entry<Predicate, PredicateInfo> entry : predicates.entrySet()) {
            this.predicates.put(entry.getKey(), entry.getValue());
        }
        this.closedPredicates = new HashSet<Predicate>();
        if (closed != null) {
            this.closedPredicates.addAll(closed);
        }
        this.cache = new AtomCache(this);
        this.closed = false;
        this.readOnlyDatabase = new ReadOnlyDatabase(this);
    }

    @Override
    public Set<StandardPredicate> getRegisteredPredicates() {
        HashSet<StandardPredicate> standardPredicates = new HashSet<StandardPredicate>();
        for (Predicate predicate : this.predicates.keySet()) {
            if (!(predicate instanceof StandardPredicate)) continue;
            standardPredicates.add((StandardPredicate)predicate);
        }
        return standardPredicates;
    }

    public PredicateInfo getPredicateInfo(Predicate predicate) {
        PredicateInfo info = this.predicates.get(predicate);
        if (info == null) {
            throw new IllegalArgumentException("Predicate not registered with database.");
        }
        return info;
    }

    @Override
    public GroundAtom getAtom(Predicate predicate, Constant ... arguments) {
        if (this.closed) {
            throw new IllegalStateException("Cannot query atom from closed database.");
        }
        if (predicate instanceof StandardPredicate) {
            return this.getAtom((StandardPredicate)predicate, arguments);
        }
        if (predicate instanceof FunctionalPredicate) {
            return this.getAtom((FunctionalPredicate)predicate, arguments);
        }
        throw new IllegalArgumentException("Unknown predicate type: " + predicate.getClass().toString());
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean deleteAtom(GroundAtom atom) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public int countAllGroundAtoms(StandardPredicate predicate) {
        ArrayList<Integer> partitions = new ArrayList<Integer>();
        partitions.addAll(this.readIDs);
        partitions.add(this.writeID);
        return this.countAllGroundAtoms(predicate, partitions);
    }

    @Override
    public int countAllGroundRandomVariableAtoms(StandardPredicate predicate) {
        if (this.isClosed(predicate)) {
            return 0;
        }
        ArrayList<Integer> partitions = new ArrayList<Integer>(1);
        partitions.add(this.writeID);
        return this.countAllGroundAtoms(predicate, partitions);
    }

    @Override
    public List<GroundAtom> getAllGroundAtoms(StandardPredicate predicate) {
        ArrayList<Integer> partitions = new ArrayList<Integer>();
        partitions.addAll(this.readIDs);
        partitions.add(this.writeID);
        return this.getAllGroundAtoms(predicate, partitions);
    }

    @Override
    public List<RandomVariableAtom> getAllGroundRandomVariableAtoms(StandardPredicate predicate) {
        if (this.isClosed(predicate)) {
            return new ArrayList<RandomVariableAtom>();
        }
        ArrayList<Integer> partitions = new ArrayList<Integer>(1);
        partitions.add(this.writeID);
        List<GroundAtom> groundAtoms = this.getAllGroundAtoms(predicate, partitions);
        ArrayList<RandomVariableAtom> atoms = new ArrayList<RandomVariableAtom>(groundAtoms.size());
        for (GroundAtom atom : groundAtoms) {
            atoms.add((RandomVariableAtom)atom);
        }
        return atoms;
    }

    @Override
    public List<ObservedAtom> getAllGroundObservedAtoms(StandardPredicate predicate) {
        List<GroundAtom> groundAtoms = this.getAllGroundAtoms(predicate, this.readIDs);
        ArrayList<ObservedAtom> atoms = new ArrayList<ObservedAtom>(groundAtoms.size());
        for (GroundAtom atom : groundAtoms) {
            atoms.add((ObservedAtom)atom);
        }
        return atoms;
    }

    @Override
    public void commit(Iterable<RandomVariableAtom> atoms) {
        this.commit(atoms, this.writeID);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void commit(Iterable<RandomVariableAtom> atoms, int partitionId) {
        if (this.closed) {
            throw new IllegalStateException("Cannot commit on a closed database.");
        }
        HashMap atomsByPredicate = new HashMap();
        for (RandomVariableAtom atom : atoms) {
            if (!atomsByPredicate.containsKey(atom.getPredicate())) {
                atomsByPredicate.put(atom.getPredicate(), new ArrayList());
            }
            ((List)atomsByPredicate.get(atom.getPredicate())).add(atom);
        }
        try (Connection connection = this.getConnection();){
            for (Map.Entry entry : atomsByPredicate.entrySet()) {
                try {
                    PreparedStatement statement = this.getAtomUpsert(connection, this.getPredicateInfo((Predicate)entry.getKey()));
                    Throwable throwable = null;
                    try {
                        int batchSize = 0;
                        for (RandomVariableAtom atom : (List)entry.getValue()) {
                            statement.setInt(1, partitionId);
                            statement.setDouble(2, atom.getValue());
                            Constant[] arguments = atom.getArguments();
                            for (int i = 0; i < arguments.length; ++i) {
                                this.setAtomArgument(statement, arguments[i], i + 3);
                            }
                            statement.addBatch();
                            if (++batchSize < 2500) continue;
                            statement.executeBatch();
                            statement.clearBatch();
                            batchSize = 0;
                        }
                        if (batchSize > 0) {
                            statement.executeBatch();
                            statement.clearBatch();
                        }
                        statement.clearParameters();
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (SQLException ex) {
                    throw new RuntimeException("Error doing batch commit for: " + entry.getKey(), ex);
                    return;
                }
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error doing batch commit.", ex);
        }
    }

    @Override
    public void commit(RandomVariableAtom atom) {
        ArrayList<RandomVariableAtom> atoms = new ArrayList<RandomVariableAtom>(1);
        atoms.add(atom);
        this.commit(atoms);
    }

    @Override
    public void moveToWritePartition(StandardPredicate predicate, int oldPartitionId) {
        PredicateInfo predicateInfo = this.getPredicateInfo(predicate);
        try (Connection connection = this.getConnection();
             PreparedStatement statement = predicateInfo.createPartitionMoveStatement(connection, oldPartitionId, this.writeID);){
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error moving partitions for: " + predicate, ex);
        }
    }

    @Override
    public ResultList executeGroundingQuery(Formula formula) {
        return this.executeQuery(formula, false);
    }

    @Override
    public ResultList executeQuery(DatabaseQuery query) {
        return this.executeQuery(query.getFormula(), query.getDistinct());
    }

    private ResultList executeQuery(Formula formula, boolean isDistinct) {
        VariableTypeMap varTypes = formula.collectVariables(new VariableTypeMap());
        HashSet<Variable> projectTo = new HashSet<Variable>(varTypes.getVariables());
        Formula2SQL sqler = new Formula2SQL(projectTo, this, isDistinct);
        String queryString = sqler.getSQL(formula);
        Map<Variable, Integer> projectionMap = sqler.getProjectionMap();
        return this.executeQuery(projectionMap, varTypes, queryString);
    }

    public ResultList executeQuery(Map<Variable, Integer> projectionMap, VariableTypeMap varTypes, String queryString) {
        if (this.closed) {
            throw new IllegalStateException("Cannot perform query on database that was closed.");
        }
        log.trace(queryString);
        RDBMSResultList results = new RDBMSResultList(projectionMap.size());
        for (Map.Entry<Variable, Integer> projection : projectionMap.entrySet()) {
            results.setVariable(projection.getKey(), projection.getValue());
        }
        int[] orderedIndexes = new int[projectionMap.size()];
        ConstantType[] orderedTypes = new ConstantType[projectionMap.size()];
        for (Map.Entry<Variable, Integer> entry : results.getVariableMap().entrySet()) {
            Variable variable = entry.getKey();
            int index = entry.getValue();
            orderedIndexes[index] = projectionMap.get(variable);
            orderedTypes[index] = varTypes.getType(variable);
        }
        try (Connection connection = this.getConnection();
             Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(queryString);){
            while (resultSet.next()) {
                Constant[] res = new Constant[projectionMap.size()];
                for (int i = 0; i < res.length; ++i) {
                    res[i] = this.extractConstantFromResult(resultSet, orderedIndexes[i], orderedTypes[i]);
                }
                results.addResult(res);
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error executing database query: [" + queryString + "]", ex);
        }
        log.trace("Number of results: {}", (Object)results.size());
        return results;
    }

    @Override
    public boolean isClosed(StandardPredicate predicate) {
        return this.closedPredicates.contains(predicate);
    }

    @Override
    public DataStore getDataStore() {
        return this.parentDataStore;
    }

    @Override
    public AtomCache getAtomCache() {
        return this.cache;
    }

    public List<Partition> getReadPartitions() {
        return Collections.unmodifiableList(this.readPartitions);
    }

    public Partition getWritePartition() {
        return this.writePartition;
    }

    private Connection getConnection() {
        return this.parentDataStore.getConnection();
    }

    @Override
    public void close() {
        if (this.closed) {
            throw new IllegalStateException("Cannot close database after it has been closed.");
        }
        this.parentDataStore.releasePartitions(this);
        this.readOnlyDatabase = null;
        this.closed = true;
    }

    private PreparedStatement getAtomQuery(Connection connection, PredicateInfo predicate, Constant[] arguments) {
        PreparedStatement statement = predicate.createQueryStatement(connection, this.readIDs);
        try {
            for (int i = 0; i < arguments.length; ++i) {
                this.setAtomArgument(statement, arguments[i], i + 1);
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Failed to set prepared statement atom arguments for " + predicate.predicate() + ".");
        }
        return statement;
    }

    private PreparedStatement getAtomUpsert(Connection connection, PredicateInfo predicate) {
        return predicate.createUpsertStatement(connection, this.parentDataStore.getDriver());
    }

    private PreparedStatement getAtomDelete(Connection connection, PredicateInfo predicate, Term[] arguments) {
        PreparedStatement statement = predicate.createDeleteStatement(connection, this.writeID);
        try {
            for (int i = 0; i < arguments.length; ++i) {
                this.setAtomArgument(statement, arguments[i], i + 1);
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Failed to set prepared statement atom arguments for " + predicate.predicate() + ".");
        }
        return statement;
    }

    private Constant extractConstantFromResult(ResultSet results, int columnIndex, ConstantType type) {
        try {
            switch (type) {
                case Double: {
                    return new DoubleAttribute(results.getDouble(columnIndex + 1));
                }
                case Integer: {
                    return new IntegerAttribute(results.getInt(columnIndex + 1));
                }
                case String: {
                    return new StringAttribute(results.getString(columnIndex + 1));
                }
                case Long: {
                    return new LongAttribute(results.getLong(columnIndex + 1));
                }
                case Date: {
                    return new DateAttribute(new DateTime(results.getDate(columnIndex + 1).getTime()));
                }
                case UniqueIntID: {
                    return new UniqueIntID(results.getInt(columnIndex + 1));
                }
                case UniqueStringID: {
                    return new UniqueStringID(results.getString(columnIndex + 1));
                }
            }
            throw new IllegalArgumentException("Unknown argument type: " + (Object)((Object)type));
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error extracting constant from ResultSet.", ex);
        }
    }

    private GroundAtom extractGroundAtomFromResult(ResultSet resultSet, StandardPredicate predicate, Constant[] arguments) throws SQLException {
        int partition;
        double value = resultSet.getDouble("value");
        if (resultSet.wasNull()) {
            value = Double.NaN;
        }
        if ((partition = resultSet.getInt("partition_id")) == this.writeID) {
            if (this.isClosed(predicate)) {
                return this.cache.instantiateObservedAtom(predicate, arguments, value);
            }
            return this.cache.instantiateRandomVariableAtom(predicate, arguments, value);
        }
        return this.cache.instantiateObservedAtom(predicate, arguments, value);
    }

    private GroundAtom getAtom(StandardPredicate predicate, Constant ... arguments) {
        return this.getAtom(predicate, true, arguments);
    }

    private GroundAtom getAtom(StandardPredicate predicate, boolean create, Constant ... arguments) {
        QueryAtom queryAtom = new QueryAtom(predicate, arguments);
        GroundAtom result = this.cache.getCachedAtom(queryAtom);
        if (result != null) {
            return result;
        }
        return this.fetchAtom(predicate, create, arguments);
    }

    private GroundAtom fetchAtom(StandardPredicate predicate, boolean create, Constant ... arguments) {
        this.getPredicateInfo(predicate);
        GroundAtom result = this.queryDBForAtom(predicate, arguments);
        if (result != null || !create) {
            return result;
        }
        result = this.isClosed(predicate) ? this.cache.instantiateObservedAtom(predicate, arguments, 0.0) : this.cache.instantiateRandomVariableAtom(predicate, arguments, 0.0);
        return result;
    }

    /*
     * Exception decompiling
     */
    private GroundAtom queryDBForAtom(StandardPredicate predicate, Constant[] arguments) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public boolean hasAtom(StandardPredicate predicate, Constant ... arguments) {
        return this.getAtom(predicate, false, arguments) != null;
    }

    private List<GroundAtom> getAllGroundAtoms(StandardPredicate predicate, List<Integer> partitions) {
        ArrayList<GroundAtom> atoms = new ArrayList<GroundAtom>();
        PredicateInfo predicateInfo = this.getPredicateInfo(predicate);
        List<String> argumentCols = predicateInfo.argumentColumns();
        Constant[] arguments = new Constant[argumentCols.size()];
        try (Connection connection = this.getConnection();
             PreparedStatement statement = predicateInfo.createQueryAllStatement(connection, partitions);
             ResultSet results = statement.executeQuery();){
            while (results.next()) {
                for (int i = 0; i < argumentCols.size(); ++i) {
                    arguments[i] = this.extractConstantFromResult(results, i + 2, predicate.getArgumentType(i));
                }
                atoms.add(this.extractGroundAtomFromResult(results, predicate, arguments));
            }
        }
        catch (SQLException ex) {
            throw new RuntimeException("Error fetching all ground atoms for: " + predicate, ex);
        }
        return atoms;
    }

    /*
     * Exception decompiling
     */
    private int countAllGroundAtoms(StandardPredicate predicate, List<Integer> partitions) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private GroundAtom getAtom(FunctionalPredicate predicate, Constant ... arguments) {
        QueryAtom queryAtom = new QueryAtom(predicate, arguments);
        GroundAtom result = this.cache.getCachedAtom(queryAtom);
        if (result != null) {
            return result;
        }
        double value = predicate.computeValue(this.readOnlyDatabase, arguments);
        return this.cache.instantiateObservedAtom(predicate, arguments, value);
    }

    private void setAtomArgument(PreparedStatement statement, Term argument, int index) throws SQLException {
        if (argument instanceof IntegerAttribute) {
            statement.setInt(index, ((IntegerAttribute)argument).getValue());
        } else if (argument instanceof DoubleAttribute) {
            statement.setDouble(index, ((DoubleAttribute)argument).getValue());
        } else if (argument instanceof StringAttribute) {
            statement.setString(index, ((StringAttribute)argument).getValue());
        } else if (argument instanceof LongAttribute) {
            statement.setLong(index, ((LongAttribute)argument).getValue());
        } else if (argument instanceof DateAttribute) {
            statement.setDate(index, new Date(((DateAttribute)argument).getValue().getMillis()));
        } else if (argument instanceof UniqueIntID) {
            statement.setInt(index, ((UniqueIntID)argument).getID());
        } else if (argument instanceof UniqueStringID) {
            statement.setString(index, ((UniqueStringID)argument).getID());
        } else {
            throw new IllegalArgumentException("Unknown argument type: " + argument.getClass());
        }
    }
}

