/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.database.rdbms.driver;

import com.healthmarketscience.sqlbuilder.CreateTableQuery;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.linqs.psl.database.Partition;
import org.linqs.psl.database.rdbms.PredicateInfo;
import org.linqs.psl.database.rdbms.driver.DatabaseDriver;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.util.Parallel;

public class H2DatabaseDriver
implements DatabaseDriver {
    private final HikariDataSource dataSource;

    public H2DatabaseDriver(Type dbType, String path, boolean clearDB) {
        try {
            Class.forName("org.h2.Driver");
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Could not find H2 driver. Please check classpath", ex);
        }
        String connectionString = null;
        switch (dbType) {
            case Disk: {
                connectionString = "jdbc:h2:" + path;
                break;
            }
            case Memory: {
                connectionString = "jdbc:h2:mem:" + path;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown database type: " + (Object)((Object)dbType));
            }
        }
        HikariConfig config = new HikariConfig();
        config.setJdbcUrl(connectionString);
        config.setMaximumPoolSize(Math.min(8, Parallel.NUM_THREADS * 2));
        this.dataSource = new HikariDataSource(config);
        if (clearDB) {
            this.clearDB();
        }
    }

    @Override
    public void close() {
        this.dataSource.close();
    }

    @Override
    public Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException ex) {
            throw new RuntimeException("Failed to get connection from pool.", ex);
        }
    }

    private void clearDB() {
        try (Connection connection = this.getConnection();
             Statement stmt = connection.createStatement();){
            stmt.executeUpdate("DROP ALL OBJECTS");
        }
        catch (SQLException e) {
            throw new RuntimeException("Could not clear database.", e);
        }
    }

    @Override
    public boolean supportsBulkCopy() {
        return false;
    }

    @Override
    public void bulkCopy(String path, String delimiter, boolean hasTruth, PredicateInfo predicateInfo, Partition partition) {
        throw new UnsupportedOperationException("H2 does not support bulk copy.");
    }

    @Override
    public String getTypeName(ConstantType type) {
        switch (type) {
            case Double: {
                return "DOUBLE";
            }
            case Integer: {
                return "INT";
            }
            case String: {
                return "VARCHAR";
            }
            case Long: {
                return "BIGINT";
            }
            case Date: {
                return "DATE";
            }
            case UniqueIntID: {
                return "INT";
            }
            case UniqueStringID: {
                return "VARCHAR(255)";
            }
        }
        throw new IllegalStateException("Unknown ConstantType: " + (Object)((Object)type));
    }

    @Override
    public String getSurrogateKeyColumnDefinition(String columnName) {
        return columnName + " BIGINT IDENTITY PRIMARY KEY";
    }

    @Override
    public String getDoubleTypeName() {
        return "DOUBLE";
    }

    @Override
    public String getUpsert(String tableName, String[] columns, String[] keyColumns) {
        ArrayList<String> sql = new ArrayList<String>();
        sql.add("MERGE INTO " + tableName + "");
        sql.add("\t(" + StringUtils.join((Object[])columns, ", ") + ")");
        sql.add("KEY");
        sql.add("\t(" + StringUtils.join((Object[])keyColumns, ", ") + ")");
        sql.add("VALUES");
        sql.add("\t(" + StringUtils.repeat("?", ", ", columns.length) + ")");
        return StringUtils.join(sql, "\n");
    }

    @Override
    public String finalizeCreateTable(CreateTableQuery createTable) {
        return ((CreateTableQuery)createTable.validate()).toString();
    }

    @Override
    public String getStringAggregate(String columnName, String delimiter, boolean distinct) {
        if (delimiter.contains("'")) {
            throw new IllegalArgumentException("Delimiter (" + delimiter + ") may not contain a single quote.");
        }
        return String.format("GROUP_CONCAT(DISTINCT CAST(%s AS TEXT) SEPARATOR '%s')", columnName, delimiter);
    }

    public static enum Type {
        Disk,
        Memory;

    }
}

