/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.evaluation.statistics;

import org.linqs.psl.database.Database;
import org.linqs.psl.database.Queries;
import org.linqs.psl.evaluation.statistics.DiscretePredictionStatistics;
import org.linqs.psl.evaluation.statistics.PredictionComparator;
import org.linqs.psl.evaluation.statistics.filter.AtomFilter;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.predicate.StandardPredicate;

public class DiscretePredictionComparator
implements PredictionComparator {
    public static final double DEFAULT_THRESHOLD = 0.5;
    private final Database result;
    private Database baseline;
    private double threshold;

    public DiscretePredictionComparator(Database result) {
        this(result, null, 0.5);
    }

    public DiscretePredictionComparator(Database result, Database baseline, double threshold) {
        this.result = result;
        this.baseline = baseline;
        this.threshold = threshold;
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public void setBaseline(Database db) {
        this.baseline = db;
    }

    @Override
    public void setResultFilter(AtomFilter af) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DiscretePredictionStatistics compare(StandardPredicate predicate) {
        int tp = 0;
        int fn = 0;
        int tn = 0;
        int fp = 0;
        for (GroundAtom truthAtom : Queries.getAllAtoms(this.baseline, predicate)) {
            boolean predicated;
            GroundAtom resultAtom;
            if (!(truthAtom instanceof ObservedAtom) || (resultAtom = this.result.getAtom(truthAtom.getPredicate(), truthAtom.getArguments())) instanceof ObservedAtom) continue;
            boolean expected = truthAtom.getValue() >= this.threshold;
            boolean bl = predicated = resultAtom.getValue() >= this.threshold;
            if (predicated && expected) {
                ++tp;
                continue;
            }
            if (!predicated && expected) {
                ++fn;
                continue;
            }
            if (predicated && !expected) {
                ++fp;
                continue;
            }
            ++tn;
        }
        return new DiscretePredictionStatistics(tp, fp, tn, fn, this.threshold);
    }
}

