/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.evaluation.statistics;

import org.linqs.psl.evaluation.statistics.PredictionStatistics;

public class DiscretePredictionStatistics
implements PredictionStatistics {
    private final int tp;
    private final int fp;
    private final int fn;
    private final int tn;
    private final double threshold;

    public DiscretePredictionStatistics(int tp, int fp, int tn, int fn, double threshold) {
        this.tp = tp;
        this.fp = fp;
        this.tn = tn;
        this.fn = fn;
        this.threshold = threshold;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public double getPrecision(BinaryClass binaryClass) {
        int misses;
        int hits;
        if (binaryClass == BinaryClass.POSITIVE) {
            hits = this.tp;
            misses = this.fp;
        } else {
            hits = this.tn;
            misses = this.fn;
        }
        if (hits + misses == 0) {
            return 0.0;
        }
        return (double)hits / (double)(hits + misses);
    }

    public double getRecall(BinaryClass binaryClass) {
        int misses;
        int hits;
        if (binaryClass == BinaryClass.POSITIVE) {
            hits = this.tp;
            misses = this.fn;
        } else {
            hits = this.tn;
            misses = this.fp;
        }
        if (hits + misses == 0) {
            return 0.0;
        }
        return (double)hits / (double)(hits + misses);
    }

    public double getF1(BinaryClass binaryClass) {
        double rec;
        double prec = this.getPrecision(binaryClass);
        double sum = prec + (rec = this.getRecall(binaryClass));
        if (sum == 0.0) {
            return 0.0;
        }
        return 2.0 * (prec * rec) / sum;
    }

    public double getAccuracy() {
        int numAtoms = this.getNumAtoms();
        if (numAtoms == 0) {
            return 0.0;
        }
        return (double)(this.tp + this.tn) / (double)numAtoms;
    }

    @Override
    public double getError() {
        return this.fp + this.fn;
    }

    @Override
    public int getNumAtoms() {
        return this.tp + this.fp + this.tn + this.fn;
    }

    public static enum BinaryClass {
        NEGATIVE,
        POSITIVE;

    }
}

