/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.evaluation.statistics;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.Queries;
import org.linqs.psl.evaluation.statistics.RankingScore;
import org.linqs.psl.evaluation.statistics.ResultComparator;
import org.linqs.psl.evaluation.statistics.filter.AtomFilter;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RankingComparator
implements ResultComparator {
    public static final double DEFAULT_THRESHOLD = 0.5;
    private static final Logger log = LoggerFactory.getLogger(RankingComparator.class);
    private final Database result;
    private Database baseline;
    private double threshold;

    public RankingComparator(Database result, Database baseline, double threshold) {
        this.result = result;
        this.baseline = baseline;
        this.threshold = threshold;
    }

    public RankingComparator(Database result) {
        this(result, null, 0.5);
    }

    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    @Override
    public void setBaseline(Database db) {
        this.baseline = db;
    }

    @Override
    public void setResultFilter(AtomFilter af) {
        throw new UnsupportedOperationException();
    }

    public RankingScore compare(StandardPredicate predicate) {
        List<GroundAtom> resultAtoms = Queries.getAllAtoms(this.result, predicate);
        Collections.sort(resultAtoms, new AtomComparator());
        log.trace("Collected and sorted result atoms. Size: {}", (Object)resultAtoms.size());
        List<GroundAtom> baselineAtoms = Queries.getAllAtoms(this.baseline, predicate);
        Collections.sort(baselineAtoms, new AtomComparator());
        log.trace("Collected and sorted base atoms. Size: {}", (Object)baselineAtoms.size());
        return new RankingScore(baselineAtoms, resultAtoms, this.threshold);
    }

    private class AtomComparator
    implements Comparator<GroundAtom> {
        private AtomComparator() {
        }

        @Override
        public int compare(GroundAtom a1, GroundAtom a2) {
            if (a1.getValue() < a2.getValue()) {
                return 1;
            }
            if (a1.getValue() == a2.getValue()) {
                return a1.toString().compareTo(a2.toString());
            }
            return -1;
        }
    }
}

