/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.evaluation.statistics;

import java.util.Iterator;
import java.util.List;
import org.linqs.psl.model.atom.GroundAtom;

public class RankingScore {
    private static final boolean DEFAULT_SKIP_MISSING_TRUTH = true;
    private List<GroundAtom> truth;
    private List<GroundAtom> predicted;
    private double threshold;
    private boolean skipMissingTruth;

    public RankingScore(List<GroundAtom> truth, List<GroundAtom> predicted, double threshold) {
        this(truth, predicted, threshold, true);
    }

    public RankingScore(List<GroundAtom> truth, List<GroundAtom> predicted, double threshold, boolean skipMissingTruth) {
        this.truth = truth;
        this.predicted = predicted;
        this.threshold = threshold;
        this.skipMissingTruth = skipMissingTruth;
    }

    public double kendall() {
        double score = 0.0;
        Iterator<GroundAtom> baseItrI = this.truth.iterator();
        baseItrI.next();
        int i = 1;
        while (baseItrI.hasNext()) {
            GroundAtom baseAtomI = baseItrI.next();
            ++i;
            Iterator<GroundAtom> baseItrJ = this.truth.iterator();
            for (int j = 0; j < i; ++j) {
                GroundAtom baseAtomJ = baseItrJ.next();
                if (this.predicted.indexOf(baseAtomJ) <= this.predicted.indexOf(baseAtomI)) continue;
                score += 1.0;
            }
        }
        return 0.5 + (1.0 - 4.0 * score / (double)(this.truth.size() * (this.truth.size() - 1))) / 2.0;
    }

    public double auprc() {
        int totalPositives = 0;
        for (GroundAtom atom : this.truth) {
            if (!(atom.getValue() > this.threshold)) continue;
            ++totalPositives;
        }
        if (totalPositives == 0) {
            return 0.0;
        }
        double area = 0.0;
        int tp = 0;
        int fp = 0;
        double prevY = 1.0;
        double prevX = 0.0;
        for (GroundAtom atom : this.predicted) {
            Boolean label = this.getLabel(atom);
            if (this.skipMissingTruth && label == null) continue;
            if (label != null && label.booleanValue()) {
                ++tp;
            } else {
                ++fp;
            }
            double newY = (double)tp / (double)(tp + fp);
            double newX = (double)tp / (double)totalPositives;
            area += 0.5 * (newX - prevX) * (newY + prevY);
            prevY = newY;
            prevX = newX;
        }
        return area += 0.5 * (1.0 - prevX) * (0.0 + prevY);
    }

    public double negAUPRC() {
        int totalPositives = 0;
        for (GroundAtom atom : this.truth) {
            if (!(atom.getValue() > this.threshold)) continue;
            ++totalPositives;
        }
        int totalNegatives = this.skipMissingTruth ? this.truth.size() - totalPositives : this.predicted.size() - totalPositives;
        if (totalNegatives == 0) {
            return 0.0;
        }
        double area = 0.0;
        int fn = totalPositives;
        int tn = totalNegatives;
        double prevY = (double)tn / (double)(tn + fn);
        double prevX = 1.0;
        for (GroundAtom atom : this.predicted) {
            Boolean label = this.getLabel(atom);
            if (this.skipMissingTruth && label == null) continue;
            if (label != null && label.booleanValue()) {
                --fn;
            } else {
                --tn;
            }
            double newY = 0.0;
            if (tn + fn > 0) {
                newY = (double)tn / (double)(tn + fn);
            }
            double newX = (double)tn / (double)totalNegatives;
            area += 0.5 * (prevX - newX) * (prevY + newY);
            prevY = newY;
            prevX = newX;
        }
        return area;
    }

    public double auroc() {
        int totalPositives = 0;
        for (GroundAtom atom : this.truth) {
            if (!(atom.getValue() > this.threshold)) continue;
            ++totalPositives;
        }
        int totalNegatives = this.skipMissingTruth ? this.truth.size() - totalPositives : this.predicted.size() - totalPositives;
        double area = 0.0;
        int tp = 0;
        int fp = 0;
        double prevY = 0.0;
        double prevX = 0.0;
        for (GroundAtom atom : this.predicted) {
            Boolean label = this.getLabel(atom);
            if (this.skipMissingTruth && label == null) continue;
            if (label != null && label.booleanValue()) {
                ++tp;
            } else {
                ++fp;
            }
            double newY = (double)tp / (double)totalPositives;
            double newX = (double)fp / (double)totalNegatives;
            area += 0.5 * (newX - prevX) * (newY + prevY);
            prevY = newY;
            prevX = newX;
        }
        return area += 0.5 * (1.0 - prevX) * (1.0 + prevY);
    }

    private Boolean getLabel(GroundAtom atom) {
        int index = this.truth.indexOf(atom);
        if (index == -1) {
            return null;
        }
        return this.truth.get(index).getValue() > this.threshold;
    }
}

