/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.evaluation.statistics.filter;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Iterator;
import org.linqs.psl.evaluation.statistics.filter.AtomFilter;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.term.Term;

public class MaxValueFilter
implements AtomFilter {
    private final Predicate predicate;
    private final int argPosition;

    public MaxValueFilter(Predicate predicate, int argPosition) {
        this.predicate = predicate;
        this.argPosition = argPosition;
    }

    @Override
    public Iterator<GroundAtom> filter(Iterator<GroundAtom> input) {
        HashMap<ArgumentWrapper, GroundAtom> argMapper = new HashMap<ArgumentWrapper, GroundAtom>();
        while (input.hasNext()) {
            GroundAtom atom = input.next();
            Preconditions.checkArgument(atom.getPredicate().equals(this.predicate), "Predicate of atom does not match filter predicate!");
            ArgumentWrapper w = new ArgumentWrapper(atom.getArguments());
            GroundAtom existing = (GroundAtom)argMapper.get(w);
            if (existing != null && !(existing.getValue() < atom.getValue())) continue;
            argMapper.put(w, atom);
        }
        return argMapper.values().iterator();
    }

    private class ArgumentWrapper {
        final Term[] args;
        final int hashcode;

        ArgumentWrapper(Term[] args) {
            this.args = args;
            int hash = 0;
            for (int i = 0; i < args.length; ++i) {
                if (i == MaxValueFilter.this.argPosition) continue;
                hash *= 117;
                hash += args[i].hashCode();
            }
            this.hashcode = hash;
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object oth) {
            if (this == oth) {
                return true;
            }
            ArgumentWrapper other = (ArgumentWrapper)oth;
            for (int i = 0; i < this.args.length; ++i) {
                if (i == MaxValueFilter.this.argPosition || other.args[i].equals(this.args[i])) continue;
                return false;
            }
            return true;
        }
    }
}

