/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.evaluation.statistics.filter;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import org.linqs.psl.evaluation.statistics.filter.AtomFilter;
import org.linqs.psl.model.atom.GroundAtom;

public class OutOfBoundsFilter
implements AtomFilter {
    private final double[] bounds;

    public OutOfBoundsFilter(double[] bounds) {
        Preconditions.checkArgument(bounds[0] <= bounds[1], "Invalid bounds specified!");
        this.bounds = bounds;
    }

    @Override
    public Iterator<GroundAtom> filter(Iterator<GroundAtom> input) {
        return Iterators.filter(input, new Predicate<GroundAtom>(){

            @Override
            public boolean apply(GroundAtom atom) {
                for (int i = 0; i < atom.getArity(); ++i) {
                    double val = atom.getValue();
                    if (!(val >= OutOfBoundsFilter.this.bounds[0]) || !(val <= OutOfBoundsFilter.this.bounds[1])) continue;
                    return false;
                }
                return true;
            }
        });
    }
}

