/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.evaluation.statistics.inspector;

import org.linqs.psl.config.ConfigBundle;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.Queries;
import org.linqs.psl.evaluation.statistics.DiscretePredictionComparator;
import org.linqs.psl.evaluation.statistics.DiscretePredictionStatistics;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.reasoner.Reasoner;
import org.linqs.psl.reasoner.inspector.DatabaseReasonerInspector;
import org.linqs.psl.reasoner.inspector.ReasonerInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscreteAccuracyInspector
extends DatabaseReasonerInspector {
    private static final Logger log = LoggerFactory.getLogger(DiscreteAccuracyInspector.class);
    public static final double DEFAULT_TRUTH_THRESHOLD = 0.5;
    private double truthThreshold = 0.5;

    public DiscreteAccuracyInspector(ConfigBundle config) {
        super(config);
    }

    @Override
    public boolean update(Reasoner reasoner, ReasonerInspector.ReasonerStatus status) {
        log.info("Reasoner inspection update -- " + status);
        Database rvDatabase = this.getRandomVariableDatabase();
        Database truthDatabase = this.getTruthDatabase(rvDatabase);
        DiscretePredictionComparator comparator = new DiscretePredictionComparator(rvDatabase);
        comparator.setThreshold(this.truthThreshold);
        comparator.setBaseline(truthDatabase);
        for (StandardPredicate targetPredicate : rvDatabase.getRegisteredPredicates()) {
            if (Queries.countAllGroundAtoms(truthDatabase, targetPredicate) == 0) continue;
            DiscretePredictionStatistics stats = comparator.compare(targetPredicate);
            double accuracy = stats.getAccuracy();
            double error = stats.getError();
            double positivePrecision = stats.getPrecision(DiscretePredictionStatistics.BinaryClass.POSITIVE);
            double positiveRecall = stats.getRecall(DiscretePredictionStatistics.BinaryClass.POSITIVE);
            double negativePrecision = stats.getPrecision(DiscretePredictionStatistics.BinaryClass.NEGATIVE);
            double negativeRecall = stats.getRecall(DiscretePredictionStatistics.BinaryClass.NEGATIVE);
            log.info("{} -- Accuracy: {}, Error: {}, Positive Class Precision: {}, Positive Class Recall: {}, Negative Class Precision: {}, Negative Class Recall: {},", targetPredicate.getName(), accuracy, error, positivePrecision, positiveRecall, negativePrecision, negativeRecall);
        }
        truthDatabase.close();
        log.info("Reasoner inspection update complete");
        return true;
    }
}

