/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.evaluation.statistics.inspector;

import org.linqs.psl.config.ConfigBundle;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.Queries;
import org.linqs.psl.evaluation.statistics.RankingComparator;
import org.linqs.psl.evaluation.statistics.RankingScore;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.reasoner.Reasoner;
import org.linqs.psl.reasoner.inspector.DatabaseReasonerInspector;
import org.linqs.psl.reasoner.inspector.ReasonerInspector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RankingAccuracyInspector
extends DatabaseReasonerInspector {
    private static final Logger log = LoggerFactory.getLogger(RankingAccuracyInspector.class);
    public static final double DEFAULT_TRUTH_THRESHOLD = 0.5;
    public static final int DEFAULT_INSPECTION_PERIOD = 10;
    private double truthThreshold = 0.5;
    private int callCount = 0;
    private int inspectionPeriod = 10;

    public RankingAccuracyInspector(ConfigBundle config) {
        super(config);
    }

    @Override
    public boolean update(Reasoner reasoner, ReasonerInspector.ReasonerStatus status) {
        ++this.callCount;
        if (this.callCount != 1 && this.callCount % 10 != 0) {
            return true;
        }
        log.info("Reasoner inspection update -- " + status);
        Database rvDatabase = this.getRandomVariableDatabase();
        Database truthDatabase = this.getTruthDatabase(rvDatabase);
        RankingComparator comparator = new RankingComparator(rvDatabase, truthDatabase, this.truthThreshold);
        for (StandardPredicate targetPredicate : rvDatabase.getRegisteredPredicates()) {
            if (Queries.countAllGroundAtoms(truthDatabase, targetPredicate) == 0) continue;
            RankingScore stats = comparator.compare(targetPredicate);
            double auroc = stats.auroc();
            double auprc = stats.auprc();
            double negAUPRC = stats.negAUPRC();
            log.info("{} -- AUROC: {}, AUPRC+: {}, AUPRC-: {}", targetPredicate.getName(), auroc, auprc, negAUPRC);
        }
        truthDatabase.close();
        log.info("Reasoner inspection update complete");
        return true;
    }
}

