/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.atom;

import java.util.Arrays;
import java.util.Set;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.SpecialPredicate;
import org.linqs.psl.model.rule.arithmetic.expression.SummationAtomOrAtom;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.model.term.DoubleAttribute;
import org.linqs.psl.model.term.IntegerAttribute;
import org.linqs.psl.model.term.LongAttribute;
import org.linqs.psl.model.term.StringAttribute;
import org.linqs.psl.model.term.Term;
import org.linqs.psl.model.term.UniqueIntID;
import org.linqs.psl.model.term.UniqueStringID;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.util.HashCode;

public abstract class Atom
implements Formula,
SummationAtomOrAtom {
    protected final Predicate predicate;
    protected final Term[] arguments;
    protected final int hashcode;
    private int originArgumentsHashcode;

    protected Atom(Predicate p, Term[] args) {
        this.predicate = p;
        this.arguments = Arrays.copyOf(args, args.length);
        this.validate();
        this.hashcode = HashCode.build(HashCode.build(this.predicate), this.arguments);
        this.originArgumentsHashcode = Arrays.hashCode(args);
    }

    public Predicate getPredicate() {
        return this.predicate;
    }

    public int getArity() {
        return this.predicate.getArity();
    }

    public Term[] getArguments() {
        return this.arguments;
    }

    @Override
    public Formula getDNF() {
        return this;
    }

    @Override
    public Set<Atom> getAtoms(Set<Atom> atoms) {
        atoms.add(this);
        return atoms;
    }

    private void validate() {
        if (this.predicate.getArity() != this.arguments.length) {
            throw new IllegalArgumentException("Length of Schema does not match the number of arguments.");
        }
        for (int i = 0; i < this.arguments.length; ++i) {
            Object arg;
            if (this.arguments[i] == null) {
                throw new IllegalArgumentException("Arguments must not be null!");
            }
            if (this.arguments[i] instanceof Variable) continue;
            ConstantType declaredType = this.predicate.getArgumentType(i);
            if (this.predicate.getArgumentType(i).isInstance((Constant)this.arguments[i])) continue;
            if (this.arguments[i] instanceof DoubleAttribute) {
                arg = ((DoubleAttribute)this.arguments[i]).getValue();
                if (declaredType == ConstantType.String) {
                    this.arguments[i] = new StringAttribute(((Double)arg).toString());
                } else if (declaredType == ConstantType.UniqueStringID) {
                    this.arguments[i] = new UniqueStringID(((Double)arg).toString());
                }
            } else if (this.arguments[i] instanceof IntegerAttribute) {
                arg = ((IntegerAttribute)this.arguments[i]).getValue();
                if (declaredType == ConstantType.Double) {
                    this.arguments[i] = new DoubleAttribute(((Integer)arg).doubleValue());
                } else if (declaredType == ConstantType.Long) {
                    this.arguments[i] = new LongAttribute(((Integer)arg).longValue());
                } else if (declaredType == ConstantType.String) {
                    this.arguments[i] = new StringAttribute(((Integer)arg).toString());
                } else if (declaredType == ConstantType.UniqueIntID) {
                    this.arguments[i] = new UniqueIntID((Integer)arg);
                } else if (declaredType == ConstantType.UniqueStringID) {
                    this.arguments[i] = new UniqueStringID(((Integer)arg).toString());
                } else if (declaredType == ConstantType.DeferredFunctionalUniqueID) {
                    this.arguments[i] = new UniqueIntID((Integer)arg);
                }
            } else if (this.arguments[i] instanceof LongAttribute) {
                arg = ((LongAttribute)this.arguments[i]).getValue();
                if (declaredType == ConstantType.Double) {
                    this.arguments[i] = new DoubleAttribute(((Long)arg).doubleValue());
                } else if (declaredType == ConstantType.Integer) {
                    this.arguments[i] = new IntegerAttribute(((Long)arg).intValue());
                } else if (declaredType == ConstantType.String) {
                    this.arguments[i] = new StringAttribute(((Long)arg).toString());
                } else if (declaredType == ConstantType.UniqueIntID) {
                    this.arguments[i] = new UniqueIntID(((Long)arg).intValue());
                } else if (declaredType == ConstantType.UniqueStringID) {
                    this.arguments[i] = new UniqueStringID(((Long)arg).toString());
                }
            } else if (this.arguments[i] instanceof StringAttribute) {
                arg = ((StringAttribute)this.arguments[i]).getValue();
                if (declaredType == ConstantType.Double) {
                    this.arguments[i] = new DoubleAttribute(Double.valueOf((String)arg));
                } else if (declaredType == ConstantType.Integer) {
                    this.arguments[i] = new IntegerAttribute(Integer.valueOf((String)arg));
                } else if (declaredType == ConstantType.Long) {
                    this.arguments[i] = new LongAttribute(Long.valueOf((String)arg));
                } else if (declaredType == ConstantType.UniqueIntID) {
                    this.arguments[i] = new UniqueIntID(Integer.parseInt((String)arg));
                } else if (declaredType == ConstantType.UniqueStringID) {
                    this.arguments[i] = new UniqueStringID((String)arg);
                } else if (declaredType == ConstantType.DeferredFunctionalUniqueID) {
                    this.arguments[i] = new UniqueStringID((String)arg);
                }
            } else {
                if (this.arguments[i] instanceof UniqueIntID) {
                    throw new IllegalArgumentException(String.format("Expected type %s at position %d but was given: %s (%s) for predicate %s -- %s", new Object[]{this.predicate.getArgumentType(i), i, this.arguments[i], this.arguments[i].getClass().getName(), this.predicate, "Unique identifiers cannot be converted to any other type."}));
                }
                if (this.arguments[i] instanceof UniqueStringID) {
                    throw new IllegalArgumentException(String.format("Expected type %s at position %d but was given: %s (%s) for predicate %s -- %s", new Object[]{this.predicate.getArgumentType(i), i, this.arguments[i], this.arguments[i].getClass().getName(), this.predicate, "Unique identifiers cannot be converted to any other type."}));
                }
            }
            if (this.predicate.getArgumentType(i).isInstance((Constant)this.arguments[i])) continue;
            throw new IllegalArgumentException(String.format("Expected type %s at position %d but was given: %s (%s) for predicate %s", new Object[]{this.predicate.getArgumentType(i), i, this.arguments[i], this.arguments[i].getClass().getName(), this.predicate}));
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.predicate instanceof SpecialPredicate) {
            s.append("(");
            if (this.predicate == SpecialPredicate.NotEqual) {
                s.append(this.arguments[0]);
                s.append(" != ");
                s.append(this.arguments[1]);
            } else if (this.predicate == SpecialPredicate.Equal) {
                s.append(this.arguments[0]);
                s.append(" == ");
                s.append(this.arguments[1]);
            } else if (this.predicate == SpecialPredicate.NonSymmetric) {
                s.append(this.arguments[0]);
                s.append(" % ");
                s.append(this.arguments[1]);
            } else {
                throw new UnsupportedOperationException("Unrecognized SpecialPredicate: " + this.predicate);
            }
            s.append(")");
        } else {
            s.append(this.predicate.getName()).append("(");
            String connector = "";
            for (Term arg : this.arguments) {
                s.append(connector).append(arg);
                connector = ", ";
            }
            s.append(")");
        }
        return s.toString();
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object oth) {
        if (oth == this) {
            return true;
        }
        if (oth == null || !(oth instanceof Atom)) {
            return false;
        }
        Atom other = (Atom)oth;
        return this.hashCode() == other.hashCode() && this.predicate.equals(other.predicate) && (this.originArgumentsHashcode == other.originArgumentsHashcode || Arrays.deepEquals(this.arguments, other.arguments));
    }

    @Override
    public Formula flatten() {
        return this;
    }
}

