/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.atom;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.Map;
import org.linqs.psl.database.Database;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.ObservedAtom;
import org.linqs.psl.model.atom.QueryAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.Constant;

public class AtomCache {
    protected final Database db;
    protected final Map<QueryAtom, GroundAtom> cache;

    public AtomCache(Database db) {
        this.db = db;
        this.cache = new HashMap<QueryAtom, GroundAtom>();
    }

    public GroundAtom getCachedAtom(QueryAtom atom) {
        return this.cache.get(atom);
    }

    public Iterable<GroundAtom> getCachedAtoms() {
        return this.cache.values();
    }

    public Iterable<GroundAtom> getCachedAtoms(final org.linqs.psl.model.predicate.Predicate predicate) {
        return Iterables.filter(this.cache.values(), new Predicate<GroundAtom>(){

            @Override
            public boolean apply(GroundAtom atom) {
                return atom.getPredicate().equals(predicate);
            }
        });
    }

    public synchronized boolean removeCachedAtom(QueryAtom qAtom) {
        if (this.cache.containsKey(qAtom)) {
            this.cache.remove(qAtom);
            return true;
        }
        return false;
    }

    public Iterable<ObservedAtom> getCachedObservedAtoms() {
        return Iterables.filter(this.cache.values(), ObservedAtom.class);
    }

    public Iterable<RandomVariableAtom> getCachedRandomVariableAtoms() {
        return Iterables.filter(this.cache.values(), RandomVariableAtom.class);
    }

    public synchronized ObservedAtom instantiateObservedAtom(org.linqs.psl.model.predicate.Predicate predicate, Constant[] args, double value) {
        QueryAtom key = new QueryAtom(predicate, args);
        if (this.cache.containsKey(key)) {
            if (!(this.cache.get(key) instanceof ObservedAtom)) {
                throw new IllegalArgumentException("Asked to instantiate an observed atom that already exists as a random variable atom: " + key);
            }
            return (ObservedAtom)this.cache.get(key);
        }
        ObservedAtom atom = new ObservedAtom(predicate, args, this.db, value);
        this.cache.put(key, atom);
        return atom;
    }

    public synchronized RandomVariableAtom instantiateRandomVariableAtom(StandardPredicate predicate, Constant[] args, double value) {
        QueryAtom key = new QueryAtom(predicate, args);
        if (this.cache.containsKey(key)) {
            if (!(this.cache.get(key) instanceof RandomVariableAtom)) {
                throw new IllegalArgumentException("Asked to instantiate a random variable atom that already exists as an observed atom: " + key);
            }
            return (RandomVariableAtom)this.cache.get(key);
        }
        RandomVariableAtom atom = new RandomVariableAtom(predicate, args, this.db, value);
        this.cache.put(key, atom);
        return atom;
    }
}

