/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.formula;

import java.util.Set;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.formula.Disjunction;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.formula.Negation;
import org.linqs.psl.model.term.VariableTypeMap;
import org.linqs.psl.util.HashCode;

public class Implication
implements Formula {
    protected final Formula body;
    protected final Formula head;
    private final int hash;

    public Implication(Formula body, Formula head) {
        assert (body != null);
        assert (head != null);
        this.body = body;
        this.head = head;
        this.hash = HashCode.build(HashCode.build(body), head);
    }

    public Formula getBody() {
        return this.body;
    }

    public Formula getHead() {
        return this.head;
    }

    @Override
    public Formula getDNF() {
        return new Disjunction(new Negation(this.body.flatten()), this.head.flatten()).getDNF();
    }

    @Override
    public VariableTypeMap collectVariables(VariableTypeMap varMap) {
        this.body.collectVariables(varMap);
        this.head.collectVariables(varMap);
        return varMap;
    }

    @Override
    public Set<Atom> getAtoms(Set<Atom> atoms) {
        this.body.getAtoms(atoms);
        this.head.getAtoms(atoms);
        return atoms;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object otherObject) {
        if (otherObject == this) {
            return true;
        }
        if (otherObject == null || !this.getClass().isInstance(otherObject)) {
            return false;
        }
        Implication other = (Implication)otherObject;
        return this.hash == other.hash && this.body.equals(other.body) && this.head.equals(other.head);
    }

    public String toString() {
        return this.body.toString() + " >> " + this.head.toString();
    }

    @Override
    public Formula flatten() {
        return new Implication(this.body.flatten(), this.head.flatten());
    }
}

