/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.predicate;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.linqs.psl.model.function.ExternalFunction;
import org.linqs.psl.model.predicate.ExternalFunctionalPredicate;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.predicate.SpecialPredicate;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.model.term.ConstantType;

public class PredicateFactory {
    protected static final PredicateFactory instance = new PredicateFactory();
    protected final Map<String, Predicate> predicateByName = new HashMap<String, Predicate>();
    protected final Pattern predicateNamePattern = Pattern.compile("\\w+");

    protected PredicateFactory() {
        this.predicateByName.put(SpecialPredicate.Equal.getName(), SpecialPredicate.Equal);
        this.predicateByName.put(SpecialPredicate.NotEqual.getName(), SpecialPredicate.NotEqual);
        this.predicateByName.put(SpecialPredicate.NonSymmetric.getName(), SpecialPredicate.NonSymmetric);
    }

    public static PredicateFactory getFactory() {
        return instance;
    }

    public StandardPredicate createStandardPredicate(String name, ConstantType ... types) {
        Predicate p = this.predicateByName.get(name = name.toUpperCase());
        if (p != null) {
            boolean samePredicate = true;
            if (p instanceof StandardPredicate && types.length == p.getArity()) {
                for (int i = 0; i < types.length; ++i) {
                    if (p.getArgumentType(i).equals((Object)types[i])) continue;
                    samePredicate = false;
                }
            } else {
                samePredicate = false;
            }
            if (samePredicate) {
                return (StandardPredicate)p;
            }
            throw new IllegalArgumentException("Name '" + name + "' already" + " used by another Predicate: " + p);
        }
        this.checkPredicateSignature(name, types);
        StandardPredicate sp = new StandardPredicate(name, types);
        this.addPredicate(sp, name);
        return sp;
    }

    public ExternalFunctionalPredicate createExternalFunctionalPredicate(String name, ExternalFunction extFun) {
        Predicate predicate = this.predicateByName.get(name = name.toUpperCase());
        if (predicate != null) {
            if (predicate instanceof ExternalFunctionalPredicate && ((ExternalFunctionalPredicate)predicate).getExternalFunction().equals(extFun)) {
                return (ExternalFunctionalPredicate)predicate;
            }
            throw new IllegalArgumentException("Name '" + name + "' already" + " used by another Predicate: " + predicate);
        }
        this.checkPredicateSignature(name, extFun.getArgumentTypes());
        ExternalFunctionalPredicate efp = new ExternalFunctionalPredicate(name, extFun);
        this.addPredicate(efp, name);
        return efp;
    }

    protected void checkPredicateSignature(String name, ConstantType[] types) {
        if (!this.predicateNamePattern.matcher(name).matches()) {
            throw new IllegalArgumentException("Name must match \\w+");
        }
        if (types.length == 0) {
            throw new IllegalArgumentException("Predicate needs at least one ArgumentType.");
        }
        for (int i = 0; i < types.length; ++i) {
            if (types[i] != null) continue;
            throw new IllegalArgumentException("No ArgumentType may be NULL.");
        }
    }

    protected void addPredicate(Predicate p, String name) {
        this.predicateByName.put(name, p);
    }

    public Predicate getPredicate(String name) {
        return this.predicateByName.get(name.toUpperCase());
    }

    public Collection<Predicate> getPredicates() {
        return Collections.unmodifiableCollection(this.predicateByName.values());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Predicate p : this.predicateByName.values()) {
            s.append(p.toString()).append("\n");
        }
        return s.toString();
    }
}

