/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.predicate;

import org.linqs.psl.database.ReadOnlyDatabase;
import org.linqs.psl.model.predicate.FunctionalPredicate;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.ConstantType;
import org.linqs.psl.model.term.UniqueIntID;
import org.linqs.psl.model.term.UniqueStringID;

public abstract class SpecialPredicate
extends FunctionalPredicate {
    public static final SpecialPredicate Equal = new SpecialPredicate("#Equal", new ConstantType[]{ConstantType.DeferredFunctionalUniqueID, ConstantType.DeferredFunctionalUniqueID}){

        @Override
        public double computeValue(ReadOnlyDatabase db, Constant ... args) {
            SpecialPredicate.checkArguments(this.getName(), args);
            return args[0].equals(args[1]) ? 1.0 : 0.0;
        }
    };
    public static final SpecialPredicate NotEqual = new SpecialPredicate("#NotEqual", new ConstantType[]{ConstantType.DeferredFunctionalUniqueID, ConstantType.DeferredFunctionalUniqueID}){

        @Override
        public double computeValue(ReadOnlyDatabase db, Constant ... args) {
            SpecialPredicate.checkArguments(this.getName(), args);
            return !args[0].equals(args[1]) ? 1.0 : 0.0;
        }
    };
    public static final SpecialPredicate NonSymmetric = new SpecialPredicate("#NonSymmetric", new ConstantType[]{ConstantType.DeferredFunctionalUniqueID, ConstantType.DeferredFunctionalUniqueID}){

        @Override
        public double computeValue(ReadOnlyDatabase db, Constant ... args) {
            SpecialPredicate.checkArguments(this.getName(), args);
            return args[0].compareTo(args[1]) < 0 ? 1.0 : 0.0;
        }
    };

    private SpecialPredicate(String name, ConstantType[] types) {
        super(name, types);
    }

    private static final void checkArguments(String functionName, Constant[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException(functionName + " expects two arguments, got " + args.length + ".");
        }
        if (!(args[0] instanceof UniqueIntID) && !(args[0] instanceof UniqueStringID) || !(args[1] instanceof UniqueIntID) && !(args[1] instanceof UniqueStringID)) {
            throw new IllegalArgumentException(String.format("%s expects both arguments to be a Unique*ID. Instead, got: (%s, %s).", functionName, args[0].getClass().getName(), args[1].getClass().getName()));
        }
        if (args[0].getClass() != args[1].getClass()) {
            throw new IllegalArgumentException(String.format("%s expects both arguments to be Unique*IDs of the same type. Instead, got: (%s, %s).", functionName, args[0].getClass().getName(), args[1].getClass().getName()));
        }
    }
}

