/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.arithmetic;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.arithmetic.AbstractArithmeticRule;
import org.linqs.psl.reasoner.function.FunctionComparator;

public abstract class AbstractGroundArithmeticRule
implements GroundRule {
    protected final AbstractArithmeticRule rule;
    protected final double[] coeffs;
    protected final GroundAtom[] atoms;
    protected final FunctionComparator comparator;
    protected final double c;

    protected AbstractGroundArithmeticRule(AbstractArithmeticRule rule, List<Double> coeffs, List<GroundAtom> atoms, FunctionComparator comparator, double c) {
        this(rule, ArrayUtils.toPrimitive(coeffs.toArray(new Double[0])), atoms.toArray(new GroundAtom[0]), comparator, c, false);
    }

    protected AbstractGroundArithmeticRule(AbstractArithmeticRule rule, double[] coeffs, GroundAtom[] atoms, FunctionComparator comparator, double c) {
        this(rule, coeffs, atoms, comparator, c, true);
    }

    protected AbstractGroundArithmeticRule(AbstractArithmeticRule rule, double[] coeffs, GroundAtom[] atoms, FunctionComparator comparator, double c, boolean copy) {
        this.rule = rule;
        this.comparator = comparator;
        this.c = c;
        if (copy) {
            this.coeffs = Arrays.copyOf(coeffs, coeffs.length);
            this.atoms = Arrays.copyOf(atoms, atoms.length);
        } else {
            this.coeffs = coeffs;
            this.atoms = atoms;
        }
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public Set<GroundAtom> getAtoms() {
        HashSet<GroundAtom> atomSet = new HashSet<GroundAtom>();
        for (GroundAtom atom : this.atoms) {
            atomSet.add(atom);
        }
        return atomSet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.coeffs.length > 0) {
            for (int i = 0; i < this.coeffs.length; ++i) {
                if (i != 0) {
                    sb.append(" + ");
                }
                sb.append(this.coeffs[i]);
                sb.append(" * ");
                sb.append(this.atoms[i]);
            }
        } else {
            sb.append("0.0");
        }
        sb.append(" ");
        switch (this.comparator) {
            case Equality: {
                sb.append("=");
                break;
            }
            case LargerThan: {
                sb.append(">=");
                break;
            }
            case SmallerThan: {
                sb.append("<=");
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized comparator: " + (Object)((Object)this.comparator));
            }
        }
        sb.append(" ");
        sb.append(this.c);
        return sb.toString();
    }

    public double[] getCoefficients() {
        return this.coeffs;
    }

    public GroundAtom[] getOrderedAtoms() {
        return this.atoms;
    }

    public FunctionComparator getComparator() {
        return this.comparator;
    }

    public double getConstant() {
        return this.c;
    }
}

