/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.arithmetic;

import java.util.List;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.predicate.SpecialPredicate;
import org.linqs.psl.model.rule.UnweightedGroundRule;
import org.linqs.psl.model.rule.UnweightedRule;
import org.linqs.psl.model.rule.arithmetic.AbstractArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.AbstractGroundArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.UnweightedArithmeticRule;
import org.linqs.psl.reasoner.function.ConstraintTerm;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.function.FunctionSum;
import org.linqs.psl.reasoner.function.FunctionSummand;

public class UnweightedGroundArithmeticRule
extends AbstractGroundArithmeticRule
implements UnweightedGroundRule {
    protected UnweightedGroundArithmeticRule(UnweightedArithmeticRule rule, List<Double> coeffs, List<GroundAtom> atoms, FunctionComparator comparator, double c) {
        super((AbstractArithmeticRule)rule, coeffs, atoms, comparator, c);
    }

    protected UnweightedGroundArithmeticRule(UnweightedArithmeticRule rule, double[] coeffs, GroundAtom[] atoms, FunctionComparator comparator, double c) {
        super((AbstractArithmeticRule)rule, coeffs, atoms, comparator, c);
    }

    @Override
    public UnweightedRule getRule() {
        return (UnweightedRule)((Object)this.rule);
    }

    @Override
    public double getInfeasibility() {
        double sum = 0.0;
        for (int i = 0; i < this.coeffs.length; ++i) {
            if (this.atoms[i].getPredicate() instanceof SpecialPredicate) continue;
            sum += this.coeffs[i] * this.atoms[i].getValue();
        }
        switch (this.comparator) {
            case Equality: {
                return Math.abs(sum - this.c);
            }
            case LargerThan: {
                return -1.0 * Math.min(sum - this.c, 0.0);
            }
            case SmallerThan: {
                return Math.max(sum - this.c, 0.0);
            }
        }
        throw new IllegalStateException("Unrecognized comparator: " + (Object)((Object)this.comparator));
    }

    @Override
    public ConstraintTerm getConstraintDefinition() {
        FunctionSum sum = new FunctionSum();
        for (int i = 0; i < this.coeffs.length; ++i) {
            if (this.atoms[i].getPredicate() instanceof SpecialPredicate) continue;
            sum.add(new FunctionSummand(this.coeffs[i], this.atoms[i].getVariable()));
        }
        return new ConstraintTerm(sum, this.comparator, this.c);
    }

    @Override
    public String toString() {
        return super.toString() + " .";
    }
}

