/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.arithmetic;

import java.util.List;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.predicate.SpecialPredicate;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.model.rule.WeightedRule;
import org.linqs.psl.model.rule.arithmetic.AbstractArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.AbstractGroundArithmeticRule;
import org.linqs.psl.model.rule.arithmetic.WeightedArithmeticRule;
import org.linqs.psl.reasoner.function.ConstantNumber;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.function.FunctionSum;
import org.linqs.psl.reasoner.function.FunctionSummand;
import org.linqs.psl.reasoner.function.FunctionTerm;
import org.linqs.psl.reasoner.function.MaxFunction;
import org.linqs.psl.reasoner.function.PowerOfTwo;

public class WeightedGroundArithmeticRule
extends AbstractGroundArithmeticRule
implements WeightedGroundRule {
    private double weight = Double.NaN;
    private final boolean squared;

    protected WeightedGroundArithmeticRule(WeightedArithmeticRule rule, List<Double> coeffs, List<GroundAtom> atoms, FunctionComparator comparator, double c, boolean squared) {
        super((AbstractArithmeticRule)rule, coeffs, atoms, comparator, c);
        this.squared = squared;
        this.validate();
    }

    protected WeightedGroundArithmeticRule(WeightedArithmeticRule rule, double[] coeffs, GroundAtom[] atoms, FunctionComparator comparator, double c, boolean squared) {
        super((AbstractArithmeticRule)rule, coeffs, atoms, comparator, c);
        this.squared = squared;
        this.validate();
    }

    private void validate() {
        if (FunctionComparator.Equality.equals((Object)this.comparator)) {
            throw new IllegalArgumentException("WeightedGroundArithmeticRules do not support equality comparators. Create two ground rules instead, one with " + (Object)((Object)FunctionComparator.SmallerThan) + " and one with " + (Object)((Object)FunctionComparator.LargerThan) + ".");
        }
        if (!FunctionComparator.SmallerThan.equals((Object)this.comparator) && !FunctionComparator.LargerThan.equals((Object)this.comparator)) {
            throw new IllegalArgumentException("Unrecognized comparator: " + (Object)((Object)this.comparator));
        }
    }

    @Override
    public WeightedRule getRule() {
        return (WeightedRule)((Object)this.rule);
    }

    @Override
    public boolean isSquared() {
        return this.squared;
    }

    @Override
    public double getWeight() {
        if (Double.isNaN(this.weight)) {
            return this.getRule().getWeight();
        }
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public FunctionTerm getFunctionDefinition() {
        FunctionSum sum = new FunctionSum();
        for (int i = 0; i < this.coeffs.length; ++i) {
            if (this.atoms[i].getPredicate() instanceof SpecialPredicate) continue;
            sum.add(new FunctionSummand(FunctionComparator.LargerThan.equals((Object)this.comparator) ? -1.0 * this.coeffs[i] : this.coeffs[i], this.atoms[i].getVariable()));
        }
        sum.add(new FunctionSummand(FunctionComparator.LargerThan.equals((Object)this.comparator) ? 1.0 : -1.0, new ConstantNumber(this.c)));
        MaxFunction fun = new MaxFunction();
        fun.add(sum);
        fun.add(new ConstantNumber(0.0));
        return this.squared ? new PowerOfTwo(fun) : fun;
    }

    @Override
    public double getIncompatibility() {
        double sum = 0.0;
        for (int i = 0; i < this.coeffs.length; ++i) {
            if (this.atoms[i].getPredicate() instanceof SpecialPredicate) continue;
            sum += this.coeffs[i] * this.atoms[i].getValue();
        }
        sum -= this.c;
        if (FunctionComparator.LargerThan.equals((Object)this.comparator)) {
            sum *= -1.0;
        }
        return this.squared ? Math.pow(Math.max(sum, 0.0), 2.0) : Math.max(sum, 0.0);
    }

    @Override
    public String toString() {
        return "" + this.getWeight() + ": " + super.toString() + (this.squared ? " ^2" : "");
    }
}

