/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.arithmetic.expression;

import org.linqs.psl.model.atom.QueryAtom;
import org.linqs.psl.model.predicate.Predicate;
import org.linqs.psl.model.rule.arithmetic.expression.SummationAtomOrAtom;
import org.linqs.psl.model.rule.arithmetic.expression.SummationVariable;
import org.linqs.psl.model.rule.arithmetic.expression.SummationVariableOrTerm;
import org.linqs.psl.model.term.Term;

public class SummationAtom
implements SummationAtomOrAtom {
    protected final Predicate p;
    protected final SummationVariableOrTerm[] args;

    public SummationAtom(Predicate p, SummationVariableOrTerm[] args) {
        this.p = p;
        this.args = args;
        this.checkSchema();
    }

    protected void checkSchema() {
        if (this.p.getArity() != this.args.length) {
            throw new IllegalArgumentException("Length of Schema does not match the number of args.");
        }
        for (SummationVariableOrTerm arg : this.args) {
            if (arg != null) continue;
            throw new IllegalArgumentException("Arguments must not be null.");
        }
    }

    public QueryAtom getQueryAtom() {
        Term[] queryAtomArgs = new Term[this.args.length];
        for (int i = 0; i < this.args.length; ++i) {
            queryAtomArgs[i] = this.args[i] instanceof Term ? (Term)this.args[i] : ((SummationVariable)this.args[i]).getVariable();
        }
        return new QueryAtom(this.p, queryAtomArgs);
    }

    public Predicate getPredicate() {
        return this.p;
    }

    public int getArity() {
        return this.p.getArity();
    }

    public SummationVariableOrTerm[] getArguments() {
        return this.args;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(this.p.getName());
        s.append("(");
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                s.append(", ");
            }
            s.append(this.args[i]);
        }
        s.append(")");
        return s.toString();
    }

    public int hashCode() {
        return this.getQueryAtom().hashCode();
    }

    public boolean equals(Object oth) {
        if (oth == this) {
            return true;
        }
        if (oth == null || !(oth instanceof SummationAtom)) {
            return false;
        }
        if (!this.p.equals(((SummationAtom)oth).p)) {
            return false;
        }
        if (this.args.length != ((SummationAtom)oth).args.length) {
            return false;
        }
        for (int i = 0; i < this.args.length; ++i) {
            if (this.args[i].equals(((SummationAtom)oth).args[i])) continue;
            return false;
        }
        return true;
    }
}

