/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.arithmetic.expression.coefficient;

import java.util.Map;
import org.linqs.psl.model.rule.arithmetic.expression.SummationVariable;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.Coefficient;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.ConstantNumber;
import org.linqs.psl.util.MathUtils;

public class Divide
extends Coefficient {
    protected final Coefficient c1;
    protected final Coefficient c2;

    public Divide(Coefficient c1, Coefficient c2) {
        this.c1 = c1;
        this.c2 = c2;
        if (c2 instanceof ConstantNumber && MathUtils.isZero(((ConstantNumber)c2).value)) {
            throw new ArithmeticException("Coefficient divides by zero");
        }
    }

    @Override
    public double getValue(Map<SummationVariable, Integer> subs) {
        double lhs = this.c1.getValue(subs);
        double rhs = this.c2.getValue(subs);
        if (MathUtils.isZero(rhs)) {
            throw new ArithmeticException("Coefficient divides by zero");
        }
        return lhs / rhs;
    }

    public String toString() {
        return "(" + this.c1.toString() + " / " + this.c2.toString() + ")";
    }

    @Override
    public Coefficient simplify() {
        Coefficient lhs = this.c1.simplify();
        Coefficient rhs = this.c2.simplify();
        if (rhs instanceof ConstantNumber && MathUtils.isZero(((ConstantNumber)rhs).value)) {
            throw new ArithmeticException("Coefficient divides by zero");
        }
        if (lhs instanceof ConstantNumber && MathUtils.isZero(((ConstantNumber)lhs).value)) {
            return new ConstantNumber(0.0);
        }
        if (rhs instanceof ConstantNumber && MathUtils.equals(((ConstantNumber)rhs).value, 1.0)) {
            return lhs;
        }
        if (lhs instanceof ConstantNumber && rhs instanceof ConstantNumber) {
            return new ConstantNumber(this.getValue(null));
        }
        return new Divide(lhs, rhs);
    }
}

