/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.arithmetic.expression.coefficient;

import java.util.Map;
import org.linqs.psl.model.rule.arithmetic.expression.SummationVariable;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.Coefficient;
import org.linqs.psl.model.rule.arithmetic.expression.coefficient.ConstantNumber;
import org.linqs.psl.util.MathUtils;

public class Multiply
extends Coefficient {
    protected final Coefficient c1;
    protected final Coefficient c2;

    public Multiply(Coefficient c1, Coefficient c2) {
        this.c1 = c1;
        this.c2 = c2;
    }

    @Override
    public double getValue(Map<SummationVariable, Integer> subs) {
        return this.c1.getValue(subs) * this.c2.getValue(subs);
    }

    public String toString() {
        return "(" + this.c1.toString() + " * " + this.c2.toString() + ")";
    }

    @Override
    public Coefficient simplify() {
        Coefficient lhs = this.c1.simplify();
        Coefficient rhs = this.c2.simplify();
        if (lhs instanceof ConstantNumber && MathUtils.isZero(((ConstantNumber)lhs).value)) {
            return new ConstantNumber(0.0);
        }
        if (rhs instanceof ConstantNumber && MathUtils.isZero(((ConstantNumber)rhs).value)) {
            return new ConstantNumber(0.0);
        }
        if (lhs instanceof ConstantNumber && MathUtils.equals(((ConstantNumber)lhs).value, 1.0)) {
            return rhs;
        }
        if (rhs instanceof ConstantNumber && MathUtils.equals(((ConstantNumber)rhs).value, 1.0)) {
            return lhs;
        }
        if (lhs instanceof ConstantNumber && rhs instanceof ConstantNumber) {
            return new ConstantNumber(this.getValue(null));
        }
        return new Multiply(lhs, rhs);
    }
}

