/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.logical;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.formula.Disjunction;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.formula.Negation;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.logical.AbstractLogicalRule;
import org.linqs.psl.reasoner.function.ConstantNumber;
import org.linqs.psl.reasoner.function.FunctionSum;
import org.linqs.psl.reasoner.function.FunctionSummand;
import org.linqs.psl.util.HashCode;

public abstract class AbstractGroundLogicalRule
implements GroundRule {
    protected final AbstractLogicalRule rule;
    protected final List<GroundAtom> posLiterals;
    protected final List<GroundAtom> negLiterals;
    protected final FunctionSum function;
    private final int hashcode;

    protected AbstractGroundLogicalRule(AbstractLogicalRule rule, List<GroundAtom> posLiterals, List<GroundAtom> negLiterals) {
        int i;
        this.rule = rule;
        this.posLiterals = Collections.unmodifiableList(new ArrayList<GroundAtom>(posLiterals));
        this.negLiterals = Collections.unmodifiableList(new ArrayList<GroundAtom>(negLiterals));
        int hash = HashCode.build(rule);
        this.function = new FunctionSum();
        for (i = 0; i < posLiterals.size(); ++i) {
            this.function.add(new FunctionSummand(1.0, posLiterals.get(i).getVariable()));
            hash = HashCode.build(hash, posLiterals.get(i));
        }
        for (i = 0; i < negLiterals.size(); ++i) {
            this.function.add(new FunctionSummand(-1.0, negLiterals.get(i).getVariable()));
            hash = HashCode.build(hash, negLiterals.get(i));
        }
        this.function.add(new FunctionSummand(1.0, new ConstantNumber(1.0 - (double)posLiterals.size())));
        this.hashcode = hash;
    }

    protected FunctionSum getFunction() {
        return this.function;
    }

    @Override
    public Set<GroundAtom> getAtoms() {
        HashSet<GroundAtom> atoms = new HashSet<GroundAtom>();
        for (GroundAtom atom : this.posLiterals) {
            atoms.add(atom);
        }
        for (GroundAtom atom : this.negLiterals) {
            atoms.add(atom);
        }
        return atoms;
    }

    public double getTruthValue() {
        return 1.0 - Math.max(this.getFunction().getValue(), 0.0);
    }

    public List<GroundAtom> getPositiveAtoms() {
        return this.posLiterals;
    }

    public List<GroundAtom> getNegativeAtoms() {
        return this.negLiterals;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !(other instanceof AbstractGroundLogicalRule) || this.hashCode() != other.hashCode()) {
            return false;
        }
        AbstractGroundLogicalRule otherRule = (AbstractGroundLogicalRule)other;
        if (!this.rule.equals(otherRule.getRule())) {
            return false;
        }
        return this.posLiterals.equals(otherRule.posLiterals) && this.negLiterals.equals(otherRule.negLiterals);
    }

    public int hashCode() {
        return this.hashcode;
    }

    public String toString() {
        Formula[] literals = new Formula[this.posLiterals.size() + this.negLiterals.size()];
        for (int i = 0; i < this.posLiterals.size(); ++i) {
            literals[i] = new Negation(this.posLiterals.get(i));
        }
        for (int j = 0; j < this.negLiterals.size(); ++j) {
            literals[i++] = this.negLiterals.get(j);
        }
        return literals.length > 1 ? new Disjunction(literals).toString() : literals[0].toString();
    }
}

