/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.logical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.linqs.psl.application.groundrulestore.GroundRuleStore;
import org.linqs.psl.database.ResultList;
import org.linqs.psl.database.atom.AtomManager;
import org.linqs.psl.model.atom.Atom;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.QueryAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.formula.Formula;
import org.linqs.psl.model.formula.FormulaAnalysis;
import org.linqs.psl.model.formula.Negation;
import org.linqs.psl.model.rule.Rule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.model.rule.logical.AbstractGroundLogicalRule;
import org.linqs.psl.model.term.Constant;
import org.linqs.psl.model.term.Variable;
import org.linqs.psl.reasoner.function.FunctionSum;
import org.linqs.psl.util.HashCode;
import org.linqs.psl.util.Parallel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogicalRule
implements Rule {
    private static final Logger log = LoggerFactory.getLogger(AbstractLogicalRule.class);
    protected Formula formula;
    protected final FormulaAnalysis.DNFClause negatedDNF;
    private int hash;

    public AbstractLogicalRule(Formula formula) {
        this.formula = formula;
        FormulaAnalysis analysis = new FormulaAnalysis(new Negation(formula));
        if (analysis.getNumDNFClauses() > 1) {
            throw new IllegalArgumentException("Formula must be a disjunction of literals (or a negative literal).");
        }
        this.negatedDNF = analysis.getDNFClause(0);
        Set<Variable> unboundVariables = this.negatedDNF.getUnboundVariables();
        if (unboundVariables.size() > 0) {
            Object[] sortedVariables = unboundVariables.toArray(new Variable[unboundVariables.size()]);
            Arrays.sort(sortedVariables);
            throw new IllegalArgumentException("Any variable used in a negated (non-functional) predicate must also participate in a positive (non-functional) predicate. The following variables do not meet this requirement: [" + StringUtils.join(sortedVariables, ", ") + "].");
        }
        if (this.negatedDNF.isGround()) {
            throw new IllegalArgumentException("Formula has no Variables.");
        }
        if (!this.negatedDNF.isQueriable()) {
            throw new IllegalArgumentException("Formula is not a valid rule for unknown reason.");
        }
        this.hash = 17;
        for (Atom atom : this.negatedDNF.getPosLiterals()) {
            this.hash = HashCode.build(atom);
        }
        for (Atom atom : this.negatedDNF.getNegLiterals()) {
            this.hash = HashCode.build(atom);
        }
    }

    public Formula getFormula() {
        return this.formula;
    }

    public FormulaAnalysis.DNFClause getDNF() {
        return this.negatedDNF;
    }

    @Override
    public int groundAll(AtomManager atomManager, GroundRuleStore grs) {
        ResultList res = atomManager.executeGroundingQuery(this.negatedDNF.getQueryFormula());
        return this.groundAll(res, atomManager, grs);
    }

    public int groundAll(ResultList groundVariables, AtomManager atomManager, GroundRuleStore grs) {
        int initialCount = grs.count(this);
        Parallel.count(groundVariables.size(), new GroundWorker(atomManager, grs, groundVariables));
        int groundCount = grs.count(this) - initialCount;
        log.debug("Grounded {} instances of rule {}", (Object)groundCount, (Object)this);
        return groundCount;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof AbstractLogicalRule)) {
            return false;
        }
        AbstractLogicalRule otherRule = (AbstractLogicalRule)other;
        if (this.hash != otherRule.hash) {
            return false;
        }
        List<Atom> thisPosLiterals = this.negatedDNF.getPosLiterals();
        List<Atom> otherPosLiterals = otherRule.negatedDNF.getPosLiterals();
        if (thisPosLiterals.size() != otherPosLiterals.size()) {
            return false;
        }
        List<Atom> thisNegLiterals = this.negatedDNF.getNegLiterals();
        List<Atom> otherNegLiterals = otherRule.negatedDNF.getNegLiterals();
        if (thisNegLiterals.size() != otherNegLiterals.size()) {
            return false;
        }
        return new HashSet<Atom>(thisPosLiterals).equals(new HashSet<Atom>(otherPosLiterals)) && new HashSet<Atom>(thisNegLiterals).equals(new HashSet<Atom>(otherNegLiterals));
    }

    protected abstract AbstractGroundLogicalRule groundFormulaInstance(List<GroundAtom> var1, List<GroundAtom> var2);

    private class GroundWorker
    extends Parallel.Worker<Integer> {
        private List<GroundAtom> posLiterals;
        private List<GroundAtom> negLiterals;
        private double[] worstCaseValues;
        private AtomManager atomManager;
        private GroundRuleStore grs;
        private ResultList res;
        private Constant[][] positiveAtomArgs;
        private Constant[][] negativeAtomArgs;

        public GroundWorker(AtomManager atomManager, GroundRuleStore grs, ResultList res) {
            this.atomManager = atomManager;
            this.grs = grs;
            this.res = res;
        }

        @Override
        public void init(int id) {
            int i;
            super.init(id);
            this.posLiterals = new ArrayList<GroundAtom>(4);
            this.negLiterals = new ArrayList<GroundAtom>(4);
            int numLiterals = AbstractLogicalRule.this.negatedDNF.getPosLiterals().size() + AbstractLogicalRule.this.negatedDNF.getNegLiterals().size();
            this.worstCaseValues = new double[numLiterals];
            this.positiveAtomArgs = new Constant[AbstractLogicalRule.this.negatedDNF.getPosLiterals().size()][];
            for (i = 0; i < AbstractLogicalRule.this.negatedDNF.getPosLiterals().size(); ++i) {
                this.positiveAtomArgs[i] = new Constant[AbstractLogicalRule.this.negatedDNF.getPosLiterals().get(i).getArity()];
            }
            this.negativeAtomArgs = new Constant[AbstractLogicalRule.this.negatedDNF.getNegLiterals().size()][];
            for (i = 0; i < AbstractLogicalRule.this.negatedDNF.getNegLiterals().size(); ++i) {
                this.negativeAtomArgs[i] = new Constant[AbstractLogicalRule.this.negatedDNF.getNegLiterals().get(i).getArity()];
            }
        }

        public Object clone() {
            return new GroundWorker(this.atomManager, this.grs, this.res);
        }

        @Override
        public void work(int index, Integer ignore) {
            int j;
            GroundAtom atom = null;
            int worstCaseCount = 0;
            for (j = 0; j < AbstractLogicalRule.this.negatedDNF.getPosLiterals().size(); ++j) {
                atom = ((QueryAtom)AbstractLogicalRule.this.negatedDNF.getPosLiterals().get(j)).ground(this.atomManager, this.res, index, this.positiveAtomArgs[j]);
                this.worstCaseValues[worstCaseCount] = atom instanceof RandomVariableAtom ? 1.0 : atom.getValue();
                ++worstCaseCount;
                this.posLiterals.add(atom);
            }
            for (j = 0; j < AbstractLogicalRule.this.negatedDNF.getNegLiterals().size(); ++j) {
                atom = ((QueryAtom)AbstractLogicalRule.this.negatedDNF.getNegLiterals().get(j)).ground(this.atomManager, this.res, index, this.negativeAtomArgs[j]);
                this.worstCaseValues[worstCaseCount] = atom instanceof RandomVariableAtom ? 0.0 : atom.getValue();
                ++worstCaseCount;
                this.negLiterals.add(atom);
            }
            AbstractGroundLogicalRule groundRule = AbstractLogicalRule.this.groundFormulaInstance(this.posLiterals, this.negLiterals);
            FunctionSum function = groundRule.getFunction();
            double worstCaseValue = function.getValue(this.worstCaseValues);
            if (!(!(worstCaseValue > 1.0E-8) || function.isConstant() && groundRule instanceof WeightedGroundRule)) {
                this.grs.addGroundRule(groundRule);
            }
            this.posLiterals.clear();
            this.negLiterals.clear();
        }
    }
}

