/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.logical;

import java.util.List;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.model.rule.WeightedRule;
import org.linqs.psl.model.rule.logical.AbstractGroundLogicalRule;
import org.linqs.psl.model.rule.logical.WeightedLogicalRule;
import org.linqs.psl.reasoner.function.ConstantNumber;
import org.linqs.psl.reasoner.function.FunctionTerm;
import org.linqs.psl.reasoner.function.MaxFunction;
import org.linqs.psl.reasoner.function.PowerOfTwo;

public class WeightedGroundLogicalRule
extends AbstractGroundLogicalRule
implements WeightedGroundRule {
    private double weight = Double.NaN;
    private final boolean squared;

    protected WeightedGroundLogicalRule(WeightedLogicalRule r, List<GroundAtom> posLiterals, List<GroundAtom> negLiterals, boolean squared) {
        super(r, posLiterals, negLiterals);
        this.squared = squared;
    }

    @Override
    public WeightedRule getRule() {
        return (WeightedRule)((Object)this.rule);
    }

    @Override
    public boolean isSquared() {
        return this.squared;
    }

    @Override
    public double getWeight() {
        if (Double.isNaN(this.weight)) {
            return this.getRule().getWeight();
        }
        return this.weight;
    }

    @Override
    public void setWeight(double weight) {
        this.weight = weight;
    }

    @Override
    public FunctionTerm getFunctionDefinition() {
        if (this.posLiterals.size() + this.negLiterals.size() == 1) {
            return this.squared ? new PowerOfTwo(this.getFunction()) : this.getFunction();
        }
        return this.squared ? new PowerOfTwo(MaxFunction.of(this.getFunction(), new ConstantNumber(0.0))) : MaxFunction.of(this.getFunction(), new ConstantNumber(0.0));
    }

    @Override
    public double getIncompatibility() {
        double inc = 1.0 - this.getTruthValue();
        return this.squared ? inc * inc : inc;
    }

    @Override
    public String toString() {
        return "" + this.getWeight() + ": " + super.toString() + (this.squared ? " ^2" : "");
    }
}

