/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.misc;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.rule.UnweightedGroundRule;
import org.linqs.psl.model.rule.UnweightedRule;
import org.linqs.psl.reasoner.function.ConstraintTerm;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.function.FunctionSum;
import org.linqs.psl.reasoner.function.FunctionSummand;

public class GroundLinearConstraint
implements UnweightedGroundRule {
    private final GroundAtom[] atoms;
    private final double[] coeffs;
    private final FunctionComparator comp;
    private final double value;

    public GroundLinearConstraint(GroundAtom[] atoms, double[] coeffs, FunctionComparator comp, double value) {
        if (atoms.length != coeffs.length) {
            throw new IllegalArgumentException("Same number of atoms and coefficients must be provided.");
        }
        this.atoms = Arrays.copyOf(atoms, atoms.length);
        this.coeffs = Arrays.copyOf(coeffs, coeffs.length);
        this.comp = comp;
        this.value = value;
    }

    @Override
    public Set<GroundAtom> getAtoms() {
        HashSet<GroundAtom> atoms = new HashSet<GroundAtom>();
        atoms.addAll(atoms);
        return atoms;
    }

    @Override
    public UnweightedRule getRule() {
        return null;
    }

    @Override
    public ConstraintTerm getConstraintDefinition() {
        FunctionSum sum = new FunctionSum();
        for (int i = 0; i < this.atoms.length; ++i) {
            sum.add(new FunctionSummand(this.coeffs[i], this.atoms[i].getVariable()));
        }
        return new ConstraintTerm(sum, this.comp, this.value);
    }

    @Override
    public double getInfeasibility() {
        ConstraintTerm constraint = this.getConstraintDefinition();
        double functionValue = constraint.getFunction().getValue();
        double conValue = constraint.getValue();
        if (constraint.getComparator().equals((Object)FunctionComparator.SmallerThan) && functionValue < this.value || constraint.getComparator().equals((Object)FunctionComparator.LargerThan) && functionValue > this.value) {
            return 0.0;
        }
        return Math.abs(functionValue - conValue);
    }
}

