/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.rule.misc;

import java.util.HashSet;
import java.util.Set;
import org.linqs.psl.model.atom.GroundAtom;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.UnweightedGroundRule;
import org.linqs.psl.model.rule.UnweightedRule;
import org.linqs.psl.reasoner.function.ConstraintTerm;
import org.linqs.psl.reasoner.function.FunctionComparator;
import org.linqs.psl.reasoner.function.FunctionSum;
import org.linqs.psl.reasoner.function.FunctionSummand;

public class GroundValueConstraint
implements UnweightedGroundRule {
    private final RandomVariableAtom atom;
    private final double value;

    public GroundValueConstraint(RandomVariableAtom atom, double value) {
        this.atom = atom;
        this.value = value;
    }

    public RandomVariableAtom getAtom() {
        return this.atom;
    }

    @Override
    public Set<GroundAtom> getAtoms() {
        HashSet<GroundAtom> atoms = new HashSet<GroundAtom>();
        atoms.add(this.atom);
        return atoms;
    }

    @Override
    public UnweightedRule getRule() {
        return null;
    }

    @Override
    public ConstraintTerm getConstraintDefinition() {
        FunctionSum sum = new FunctionSum();
        sum.add(new FunctionSummand(1.0, this.atom.getVariable()));
        return new ConstraintTerm(sum, FunctionComparator.Equality, this.value);
    }

    @Override
    public double getInfeasibility() {
        return Math.abs(this.atom.getValue() - this.value);
    }
}

