/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.model.term;

import org.linqs.psl.model.term.Attribute;
import org.linqs.psl.model.term.Constant;

public class StringAttribute
implements Attribute {
    private final String value;

    public StringAttribute(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        if (this.value.length() > 28) {
            return "'" + this.value.substring(0, Math.min(this.value.length(), 25)) + "...'";
        }
        return "'" + this.value + "'";
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public int hashCode() {
        return this.value.hashCode();
    }

    @Override
    public boolean equals(Object oth) {
        if (oth == this) {
            return true;
        }
        if (oth == null || !(oth instanceof StringAttribute)) {
            return false;
        }
        return this.value.equals(((StringAttribute)oth).getValue());
    }

    @Override
    public int compareTo(Constant o) {
        if (o instanceof StringAttribute) {
            return this.value.compareTo(((StringAttribute)o).value);
        }
        return this.getClass().getSimpleName().compareTo(o.getClass().getSimpleName());
    }
}

