/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.linqs.psl.config.ConfigBundle;
import org.linqs.psl.reasoner.Reasoner;
import org.linqs.psl.reasoner.term.TermStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ExecutableReasoner
extends Reasoner {
    private static final Logger log = LoggerFactory.getLogger(ExecutableReasoner.class);
    public static final String CONFIG_PREFIX = "executablereasoner";
    public static final String EXECUTABLE_PATH_KEY = "executablereasoner.executablepath";
    public static final String CLEANUP_INPUT_KEY = "executablereasoner.cleanupinput";
    public static final boolean CLEANUP_INPUT_DEFAULT = true;
    public static final String CLEANUP_OUTPUT_KEY = "executablereasoner.cleanupoutput";
    public static final boolean CLEANUP_OUTPUT_DEFAULT = true;
    protected String executableInputPath;
    protected String executableOutputPath;
    protected String executablePath;
    protected boolean cleanupInput;
    protected boolean cleanupOutput;
    protected String[] args;

    public ExecutableReasoner(ConfigBundle config) {
        super(config);
        this.executablePath = config.getString(EXECUTABLE_PATH_KEY, "");
        this.cleanupInput = config.getBoolean(CLEANUP_INPUT_KEY, true);
        this.cleanupOutput = config.getBoolean(CLEANUP_OUTPUT_KEY, true);
    }

    public ExecutableReasoner(ConfigBundle config, String executablePath, String executableInputPath, String executableOutputPath, String ... args) {
        super(config);
        this.executablePath = executablePath;
        this.executableInputPath = executableInputPath;
        this.executableOutputPath = executableOutputPath;
        this.args = args;
        this.cleanupInput = config.getBoolean(CLEANUP_INPUT_KEY, true);
        this.cleanupOutput = config.getBoolean(CLEANUP_OUTPUT_KEY, true);
    }

    @Override
    public void optimize(TermStore termStore) {
        log.debug("Writing model file: " + this.executableInputPath);
        File modelFile = new File(this.executableInputPath);
        try {
            BufferedWriter modelWriter = new BufferedWriter(new FileWriter(modelFile));
            this.writeModel(modelWriter, termStore);
            modelWriter.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to write model file: " + this.executableInputPath, ex);
        }
        log.debug("Finished writing model file. Calling reasoner: " + this.executablePath);
        try {
            this.callReasoner();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to call external reasoner: " + this.executablePath, ex);
        }
        log.debug("Reasoner finished. Reading results file: " + this.executableOutputPath);
        File resultsFile = new File(this.executableOutputPath);
        try {
            BufferedReader resultsReader = new BufferedReader(new FileReader(resultsFile));
            this.readResults(resultsReader, termStore);
            resultsReader.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read results file: " + this.executableOutputPath, ex);
        }
        log.debug("Finished reading results file.");
    }

    protected void callReasoner() throws IOException {
        String line;
        ArrayList<String> command = new ArrayList<String>(Arrays.asList(this.args));
        command.add(0, this.executablePath);
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.redirectErrorStream(true);
        Process proc = pb.start();
        BufferedReader stdout = new BufferedReader(new InputStreamReader(proc.getInputStream()));
        while ((line = stdout.readLine()) != null) {
            log.debug(line);
        }
        stdout.close();
        int exitValue = -1;
        try {
            exitValue = proc.waitFor();
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Failed to wait for executable reasoner.", ex);
        }
        if (exitValue != 0) {
            throw new RuntimeException("Executable exited with unexpected value: " + exitValue);
        }
    }

    @Override
    public void close() {
        if (this.cleanupInput) {
            new File(this.executableInputPath).delete();
        }
        if (this.cleanupOutput) {
            new File(this.executableOutputPath).delete();
        }
    }

    protected abstract void writeModel(BufferedWriter var1, TermStore var2) throws IOException;

    protected abstract void readResults(BufferedReader var1, TermStore var2) throws IOException;
}

