/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class ThreadPool {
    private final ExecutorService pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new DaemonThreadFactory());

    public Future<?> submit(Runnable task) {
        return this.pool.submit(task);
    }

    public void shutdownAndWait() {
        this.pool.shutdown();
        try {
            while (!this.pool.awaitTermination(60L, TimeUnit.SECONDS)) {
            }
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("Interrupted waiting for pool to shutdown.", ex);
        }
    }

    private class DaemonThreadFactory
    implements ThreadFactory {
        private ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.defaultThreadFactory.newThread(r);
            thread.setDaemon(true);
            return thread;
        }
    }
}

