/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import java.util.List;
import org.apache.commons.collections4.list.UnmodifiableList;
import org.linqs.psl.reasoner.admm.term.LocalVariable;
import org.linqs.psl.reasoner.term.Term;

public abstract class ADMMObjectiveTerm
implements Term {
    protected final List<LocalVariable> variables;

    public ADMMObjectiveTerm(List<LocalVariable> variables) {
        this.variables = variables;
    }

    public void updateLagrange(float stepSize, float[] consensusValues) {
        for (int i = 0; i < this.variables.size(); ++i) {
            LocalVariable variable = this.variables.get(i);
            variable.setLagrange(variable.getLagrange() + stepSize * (variable.getValue() - consensusValues[variable.getGlobalId()]));
        }
    }

    public abstract void minimize(float var1, float[] var2);

    public List<LocalVariable> getVariables() {
        return new UnmodifiableList<LocalVariable>(this.variables);
    }
}

