/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import java.util.ArrayList;
import java.util.List;
import org.linqs.psl.application.groundrulestore.GroundRuleStore;
import org.linqs.psl.config.ConfigBundle;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.UnweightedGroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.reasoner.admm.term.ADMMObjectiveTerm;
import org.linqs.psl.reasoner.admm.term.ADMMTermStore;
import org.linqs.psl.reasoner.admm.term.HingeLossTerm;
import org.linqs.psl.reasoner.admm.term.LinearConstraintTerm;
import org.linqs.psl.reasoner.admm.term.LinearLossTerm;
import org.linqs.psl.reasoner.admm.term.LocalVariable;
import org.linqs.psl.reasoner.admm.term.SquaredHingeLossTerm;
import org.linqs.psl.reasoner.admm.term.SquaredLinearLossTerm;
import org.linqs.psl.reasoner.function.AtomFunctionVariable;
import org.linqs.psl.reasoner.function.ConstantNumber;
import org.linqs.psl.reasoner.function.ConstraintTerm;
import org.linqs.psl.reasoner.function.FunctionSum;
import org.linqs.psl.reasoner.function.FunctionSummand;
import org.linqs.psl.reasoner.function.FunctionTerm;
import org.linqs.psl.reasoner.function.MaxFunction;
import org.linqs.psl.reasoner.function.PowerOfTwo;
import org.linqs.psl.reasoner.term.TermGenerator;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.util.Parallel;

public class ADMMTermGenerator
implements TermGenerator<ADMMObjectiveTerm> {
    public ADMMTermGenerator() {
    }

    public ADMMTermGenerator(ConfigBundle config) {
    }

    @Override
    public int generateTerms(GroundRuleStore ruleStore, final TermStore<ADMMObjectiveTerm> termStore) {
        if (!(termStore instanceof ADMMTermStore)) {
            throw new IllegalArgumentException("ADMMTermGenerator requires an ADMMTermStore");
        }
        int initialSize = termStore.size();
        Parallel.foreach(ruleStore.getGroundRules(), new Parallel.Worker<GroundRule>(){

            @Override
            public void work(int index, GroundRule rule) {
                ADMMObjectiveTerm term = ADMMTermGenerator.this.createTerm(rule, (ADMMTermStore)termStore);
                if (term.variables.size() > 0) {
                    termStore.add(rule, term);
                }
            }
        });
        return termStore.size() - initialSize;
    }

    @Override
    public void updateWeights(GroundRuleStore ruleStore, TermStore<ADMMObjectiveTerm> termStore) {
        for (GroundRule groundRule : ruleStore.getGroundRules()) {
            if (!(groundRule instanceof WeightedGroundRule)) continue;
            termStore.updateWeight((WeightedGroundRule)groundRule);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ADMMObjectiveTerm createTerm(GroundRule groundRule, ADMMTermStore termStore) {
        void var3_23;
        if (groundRule instanceof WeightedGroundRule) {
            boolean squared;
            float weight = (float)((WeightedGroundRule)groundRule).getWeight();
            FunctionTerm function = ((WeightedGroundRule)groundRule).getFunctionDefinition();
            if (function instanceof PowerOfTwo) {
                squared = true;
                function = ((PowerOfTwo)function).getInnerFunction();
            } else {
                squared = false;
            }
            if (function instanceof MaxFunction) {
                if (((MaxFunction)function).size() != 2) {
                    throw new IllegalArgumentException("Max function must have one linear function and 0.0 as arguments.");
                }
                FunctionTerm innerFunction = null;
                FunctionTerm zeroTerm = null;
                FunctionTerm innerFunction0 = ((MaxFunction)function).get(0);
                FunctionTerm innerFunction1 = ((MaxFunction)function).get(1);
                if (innerFunction0 instanceof ConstantNumber && innerFunction0.getValue() == 0.0) {
                    zeroTerm = innerFunction0;
                    innerFunction = innerFunction1;
                } else if (innerFunction1 instanceof ConstantNumber && innerFunction1.getValue() == 0.0) {
                    zeroTerm = innerFunction1;
                    innerFunction = innerFunction0;
                }
                if (zeroTerm == null) {
                    throw new IllegalArgumentException("Max function must have one linear function and 0.0 as arguments.");
                }
                if (!(innerFunction instanceof FunctionSum)) throw new IllegalArgumentException("Max function must have one linear function and 0.0 as arguments.");
                Hyperplane hyperplane = this.processHyperplane((FunctionSum)innerFunction, termStore);
                if (squared) {
                    SquaredHingeLossTerm squaredHingeLossTerm = new SquaredHingeLossTerm(hyperplane.variables, hyperplane.coeffs, hyperplane.constant, weight);
                    return var3_23;
                } else {
                    HingeLossTerm hingeLossTerm = new HingeLossTerm(hyperplane.variables, hyperplane.coeffs, hyperplane.constant, weight);
                }
                return var3_23;
            } else {
                if (!(function instanceof FunctionSum)) throw new IllegalArgumentException("Unrecognized function: " + function);
                Hyperplane hyperplane = this.processHyperplane((FunctionSum)function, termStore);
                if (squared) {
                    SquaredLinearLossTerm squaredLinearLossTerm = new SquaredLinearLossTerm(hyperplane.variables, hyperplane.coeffs, 0.0f, weight);
                    return var3_23;
                } else {
                    LinearLossTerm linearLossTerm = new LinearLossTerm(hyperplane.variables, hyperplane.coeffs, weight);
                }
            }
            return var3_23;
        } else {
            if (!(groundRule instanceof UnweightedGroundRule)) throw new IllegalArgumentException("Unsupported ground rule: " + groundRule);
            ConstraintTerm constraint = ((UnweightedGroundRule)groundRule).getConstraintDefinition();
            FunctionTerm function = constraint.getFunction();
            if (!(function instanceof FunctionSum)) throw new IllegalArgumentException("Unrecognized constraint: " + constraint);
            Hyperplane hyperplane = this.processHyperplane((FunctionSum)function, termStore);
            LinearConstraintTerm linearConstraintTerm = new LinearConstraintTerm(hyperplane.variables, hyperplane.coeffs, (float)(constraint.getValue() + (double)hyperplane.constant), constraint.getComparator());
        }
        return var3_23;
    }

    private Hyperplane processHyperplane(FunctionSum sum, ADMMTermStore termStore) {
        Hyperplane hyperplane = new Hyperplane();
        for (int i = 0; i < sum.size(); ++i) {
            FunctionSummand summand = sum.get(i);
            FunctionTerm singleton = summand.getTerm();
            if (singleton instanceof AtomFunctionVariable && !singleton.isConstant()) {
                LocalVariable variable = termStore.createLocalVariable((AtomFunctionVariable)singleton);
                int localIndex = hyperplane.variables.indexOf(variable);
                if (localIndex != -1) {
                    hyperplane.coeffs.set(localIndex, new Float((double)hyperplane.coeffs.get(localIndex).floatValue() + summand.getCoefficient()));
                    continue;
                }
                hyperplane.variables.add(variable);
                hyperplane.coeffs.add(new Float(summand.getCoefficient()));
                continue;
            }
            if (singleton.isConstant()) {
                hyperplane.constant = (float)((double)hyperplane.constant - summand.getValue());
                continue;
            }
            throw new IllegalArgumentException("Unexpected summand.");
        }
        return hyperplane;
    }

    private static class Hyperplane {
        public List<LocalVariable> variables = new ArrayList<LocalVariable>();
        public List<Float> coeffs = new ArrayList<Float>();
        public float constant = 0.0f;
    }
}

