/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.linqs.psl.config.ConfigBundle;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.reasoner.admm.term.ADMMObjectiveTerm;
import org.linqs.psl.reasoner.admm.term.LocalVariable;
import org.linqs.psl.reasoner.function.AtomFunctionVariable;
import org.linqs.psl.reasoner.term.MemoryTermStore;
import org.linqs.psl.reasoner.term.TermStore;

public class ADMMTermStore
implements TermStore<ADMMObjectiveTerm> {
    public static final String CONFIG_PREFIX = "admmmemorytermstore";
    public static final String INTERNAL_STORE_KEY = "admmmemorytermstore.internalstore";
    public static final String INTERNAL_STORE_DEFAULT = "org.linqs.psl.reasoner.term.MemoryTermStore";
    private TermStore<ADMMObjectiveTerm> store;
    private Map<AtomFunctionVariable, Integer> variableIndexes;
    private List<List<LocalVariable>> localVariables;
    private int numLocalVariables;

    public ADMMTermStore() {
        this(new MemoryTermStore<ADMMObjectiveTerm>());
    }

    public ADMMTermStore(ConfigBundle config) {
        this((TermStore)config.getNewObject(INTERNAL_STORE_KEY, INTERNAL_STORE_DEFAULT));
    }

    public ADMMTermStore(TermStore<ADMMObjectiveTerm> store) {
        this.store = store;
        this.variableIndexes = new HashMap<AtomFunctionVariable, Integer>();
        this.localVariables = new ArrayList<List<LocalVariable>>();
        this.numLocalVariables = 0;
    }

    public synchronized LocalVariable createLocalVariable(AtomFunctionVariable atomVariable) {
        int globalId;
        ++this.numLocalVariables;
        if (this.variableIndexes.containsKey(atomVariable)) {
            globalId = this.variableIndexes.get(atomVariable);
        } else {
            globalId = this.variableIndexes.size();
            this.variableIndexes.put(atomVariable, globalId);
            this.localVariables.add(new ArrayList());
        }
        LocalVariable localVariable = new LocalVariable(globalId, (float)atomVariable.getValue());
        this.localVariables.get(globalId).add(localVariable);
        return localVariable;
    }

    public int getNumLocalVariables() {
        return this.numLocalVariables;
    }

    public int getNumGlobalVariables() {
        return this.variableIndexes.size();
    }

    public List<LocalVariable> getLocalVariables(int globalId) {
        return this.localVariables.get(globalId);
    }

    public void updateVariables(float[] values) {
        for (Map.Entry<AtomFunctionVariable, Integer> entry : this.variableIndexes.entrySet()) {
            entry.getKey().setValue(values[entry.getValue()]);
        }
    }

    @Override
    public void add(GroundRule rule, ADMMObjectiveTerm term) {
        this.store.add(rule, term);
    }

    @Override
    public void clear() {
        this.store.clear();
        this.variableIndexes.clear();
        this.localVariables.clear();
        this.numLocalVariables = 0;
    }

    @Override
    public void close() {
        this.clear();
        this.store.close();
        this.store = null;
        this.variableIndexes = null;
        this.localVariables = null;
    }

    @Override
    public ADMMObjectiveTerm get(int index) {
        return this.store.get(index);
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public Iterator<ADMMObjectiveTerm> iterator() {
        return this.store.iterator();
    }

    @Override
    public void updateWeight(WeightedGroundRule rule) {
        this.store.updateWeight(rule);
    }

    @Override
    public List<Integer> getTermIndices(WeightedGroundRule rule) {
        return this.store.getTermIndices(rule);
    }
}

