/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import java.util.List;
import org.linqs.psl.reasoner.admm.term.HyperplaneTerm;
import org.linqs.psl.reasoner.admm.term.LocalVariable;
import org.linqs.psl.reasoner.term.WeightedTerm;

public class HingeLossTerm
extends HyperplaneTerm
implements WeightedTerm {
    private float weight;

    HingeLossTerm(List<LocalVariable> variables, List<Float> coeffs, float constant, float weight) {
        super(variables, coeffs, constant);
        if ((double)weight < 0.0) {
            throw new IllegalArgumentException("Only non-negative weights are supported.");
        }
        this.setWeight(weight);
    }

    @Override
    public void setWeight(float weight) {
        this.weight = weight;
    }

    @Override
    public void minimize(float stepSize, float[] consensusValues) {
        LocalVariable variable;
        int i;
        float total = 0.0f;
        for (i = 0; i < this.variables.size(); ++i) {
            variable = (LocalVariable)this.variables.get(i);
            variable.setValue(consensusValues[variable.getGlobalId()] - variable.getLagrange() / stepSize);
            total += ((Float)this.coeffs.get(i)).floatValue() * variable.getValue();
        }
        if (total <= this.constant) {
            return;
        }
        total = 0.0f;
        for (i = 0; i < this.variables.size(); ++i) {
            variable = (LocalVariable)this.variables.get(i);
            variable.setValue(consensusValues[variable.getGlobalId()] - variable.getLagrange() / stepSize);
            variable.setValue(variable.getValue() - this.weight * ((Float)this.coeffs.get(i)).floatValue() / stepSize);
            total += ((Float)this.coeffs.get(i)).floatValue() * variable.getValue();
        }
        if (total >= this.constant) {
            return;
        }
        this.project(stepSize, consensusValues);
    }
}

