/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import java.util.ArrayList;
import java.util.List;
import org.linqs.psl.reasoner.admm.term.ADMMObjectiveTerm;
import org.linqs.psl.reasoner.admm.term.LocalVariable;

public abstract class HyperplaneTerm
extends ADMMObjectiveTerm {
    protected final List<Float> coeffs;
    protected final List<Float> unitNormal;
    protected final float constant;
    protected final float[] point;

    HyperplaneTerm(List<LocalVariable> variables, List<Float> coeffs, float constant) {
        super(variables);
        assert (variables.size() == coeffs.size());
        this.coeffs = coeffs;
        this.constant = constant;
        this.point = new float[variables.size()];
        if (variables.size() >= 3) {
            float length = 0.0f;
            for (Float coeff : coeffs) {
                length += coeff.floatValue() * coeff.floatValue();
            }
            length = (float)Math.sqrt(length);
            this.unitNormal = new ArrayList<Float>(coeffs.size());
            for (Float coeff : coeffs) {
                this.unitNormal.add(Float.valueOf(coeff.floatValue() / length));
            }
        } else {
            this.unitNormal = null;
        }
    }

    protected void project(float stepSize, float[] consensusValues) {
        int i;
        if (this.variables.size() == 1) {
            ((LocalVariable)this.variables.get(0)).setValue(this.constant / this.coeffs.get(0).floatValue());
            return;
        }
        if (this.variables.size() == 2) {
            float coeff0 = this.coeffs.get(0).floatValue();
            float coeff1 = this.coeffs.get(1).floatValue();
            float x0 = stepSize * consensusValues[((LocalVariable)this.variables.get(0)).getGlobalId()] - ((LocalVariable)this.variables.get(0)).getLagrange();
            x0 = (float)((double)x0 - (double)(stepSize * coeff0 / coeff1) * (-1.0 * (double)this.constant / (double)coeff1 + (double)consensusValues[((LocalVariable)this.variables.get(1)).getGlobalId()] - (double)(((LocalVariable)this.variables.get(1)).getLagrange() / stepSize)));
            x0 = (float)((double)x0 / ((double)stepSize * (1.0 + (double)(coeff0 * coeff0 / coeff1 / coeff1))));
            float x1 = (this.constant - coeff0 * x0) / coeff1;
            ((LocalVariable)this.variables.get(0)).setValue(x0);
            ((LocalVariable)this.variables.get(1)).setValue(x1);
            return;
        }
        for (int i2 = 0; i2 < this.variables.size(); ++i2) {
            this.point[i2] = consensusValues[((LocalVariable)this.variables.get(i2)).getGlobalId()] - ((LocalVariable)this.variables.get(i2)).getLagrange() / stepSize;
        }
        float multiplier = -1.0f * this.constant / this.coeffs.get(0).floatValue() * this.unitNormal.get(0).floatValue();
        for (i = 0; i < this.variables.size(); ++i) {
            multiplier += this.point[i] * this.unitNormal.get(i).floatValue();
        }
        for (i = 0; i < this.variables.size(); ++i) {
            ((LocalVariable)this.variables.get(i)).setValue(this.point[i] - multiplier * this.unitNormal.get(i).floatValue());
        }
    }
}

