/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import java.util.List;
import org.linqs.psl.reasoner.admm.term.HyperplaneTerm;
import org.linqs.psl.reasoner.admm.term.LocalVariable;
import org.linqs.psl.reasoner.function.FunctionComparator;

public class LinearConstraintTerm
extends HyperplaneTerm {
    private final FunctionComparator comparator;

    protected LinearConstraintTerm(List<LocalVariable> variables, List<Float> coeffs, float constant, FunctionComparator comparator) {
        super(variables, coeffs, constant);
        this.comparator = comparator;
    }

    @Override
    public void minimize(float stepSize, float[] consensusValues) {
        if (!this.comparator.equals((Object)FunctionComparator.Equality)) {
            float total = 0.0f;
            for (int i = 0; i < this.variables.size(); ++i) {
                LocalVariable variable = (LocalVariable)this.variables.get(i);
                variable.setValue(consensusValues[variable.getGlobalId()] - variable.getLagrange() / stepSize);
                total += ((Float)this.coeffs.get(i)).floatValue() * variable.getValue();
            }
            if (this.comparator.equals((Object)FunctionComparator.SmallerThan) && total <= this.constant || this.comparator.equals((Object)FunctionComparator.LargerThan) && total >= this.constant) {
                return;
            }
        }
        this.project(stepSize, consensusValues);
    }
}

