/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import java.util.List;
import org.linqs.psl.reasoner.admm.term.ADMMObjectiveTerm;
import org.linqs.psl.reasoner.admm.term.LocalVariable;
import org.linqs.psl.reasoner.term.WeightedTerm;

public class LinearLossTerm
extends ADMMObjectiveTerm
implements WeightedTerm {
    private final List<Float> coeffs;
    private float weight;

    LinearLossTerm(List<LocalVariable> variables, List<Float> coeffs, float weight) {
        super(variables);
        assert (variables.size() == coeffs.size());
        this.coeffs = coeffs;
        this.setWeight(weight);
    }

    @Override
    public void setWeight(float weight) {
        this.weight = weight;
    }

    @Override
    public void minimize(float stepSize, float[] consensusValues) {
        for (int i = 0; i < this.variables.size(); ++i) {
            LocalVariable variable = (LocalVariable)this.variables.get(i);
            float value = consensusValues[variable.getGlobalId()] - variable.getLagrange() / stepSize;
            variable.setValue(value -= this.weight * this.coeffs.get(i).floatValue() / stepSize);
        }
    }
}

