/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.admm.term;

import java.util.List;
import org.linqs.psl.reasoner.admm.term.LocalVariable;
import org.linqs.psl.reasoner.admm.term.SquaredHyperplaneTerm;

public class SquaredHingeLossTerm
extends SquaredHyperplaneTerm {
    public SquaredHingeLossTerm(List<LocalVariable> variables, List<Float> coeffs, float constant, float weight) {
        super(variables, coeffs, constant, weight);
    }

    @Override
    public void minimize(float stepSize, float[] consensusValues) {
        float total = 0.0f;
        for (int i = 0; i < this.variables.size(); ++i) {
            LocalVariable variable = (LocalVariable)this.variables.get(i);
            variable.setValue(consensusValues[variable.getGlobalId()] - variable.getLagrange() / stepSize);
            total += ((Float)this.coeffs.get(i)).floatValue() * variable.getValue();
        }
        if (total <= this.constant) {
            return;
        }
        this.minWeightedSquaredHyperplane(stepSize, consensusValues);
    }
}

