/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.function;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.linqs.psl.reasoner.function.ConstantNumber;
import org.linqs.psl.reasoner.function.FunctionSummand;
import org.linqs.psl.reasoner.function.FunctionTerm;

public class FunctionSum
implements Iterable<FunctionSummand>,
FunctionTerm {
    private final List<FunctionSummand> sum = new ArrayList<FunctionSummand>();
    private boolean isConstant = true;
    private boolean isLinear = true;

    public void add(FunctionSummand summand) {
        this.sum.add(summand);
        this.isConstant = this.isConstant && summand.isConstant();
        this.isLinear = this.isLinear && summand.isLinear();
    }

    @Override
    public Iterator<FunctionSummand> iterator() {
        return this.sum.iterator();
    }

    public int size() {
        return this.sum.size();
    }

    public FunctionSummand get(int pos) {
        return this.sum.get(pos);
    }

    @Override
    public double getValue() {
        double val = 0.0;
        for (int i = 0; i < this.sum.size(); ++i) {
            val += this.sum.get(i).getValue();
        }
        return val;
    }

    public double getValue(double[] values) {
        double val = 0.0;
        int valueIndex = 0;
        for (int i = 0; i < this.sum.size(); ++i) {
            FunctionSummand summand = this.sum.get(i);
            if (summand.getTerm() instanceof ConstantNumber) {
                val += summand.getValue();
                continue;
            }
            val += summand.getCoefficient() * values[valueIndex];
            ++valueIndex;
        }
        return val;
    }

    @Override
    public boolean isLinear() {
        return this.isLinear;
    }

    @Override
    public boolean isConstant() {
        return this.isConstant;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append("(");
        boolean skip = true;
        for (FunctionTerm functionTerm : this.sum) {
            if (skip) {
                skip = false;
            } else {
                string.append("+");
            }
            string.append(" " + functionTerm.toString() + " ");
        }
        string.append(")");
        return string.toString();
    }
}

