/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.function;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.linqs.psl.reasoner.function.FunctionTerm;

public class MaxFunction
implements Iterable<FunctionTerm>,
FunctionTerm {
    private final List<FunctionTerm> terms = new ArrayList<FunctionTerm>();

    public void add(FunctionTerm term) {
        this.terms.add(term);
    }

    @Override
    public Iterator<FunctionTerm> iterator() {
        return this.terms.iterator();
    }

    public int size() {
        return this.terms.size();
    }

    public FunctionTerm get(int pos) {
        return this.terms.get(pos);
    }

    @Override
    public double getValue() {
        if (this.terms.isEmpty()) {
            throw new AssertionError((Object)"Undefined max value for zero terms!");
        }
        double val = Double.NEGATIVE_INFINITY;
        for (FunctionTerm term : this.terms) {
            val = Math.max(val, term.getValue());
        }
        return val;
    }

    @Override
    public boolean isLinear() {
        for (FunctionTerm term : this.terms) {
            if (term.isLinear()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isConstant() {
        for (FunctionTerm term : this.terms) {
            if (term.isConstant()) continue;
            return false;
        }
        return true;
    }

    public static MaxFunction of(FunctionTerm ... terms) {
        MaxFunction max = new MaxFunction();
        for (FunctionTerm term : terms) {
            max.add(term);
        }
        return max;
    }

    public String toString() {
        StringBuilder string = new StringBuilder();
        string.append("Max{");
        boolean skip = true;
        for (FunctionTerm term : this.terms) {
            if (skip) {
                skip = false;
            } else {
                string.append(",");
            }
            string.append(" " + term.toString() + " ");
        }
        string.append("}");
        return string.toString();
    }
}

