/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.inspector;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.linqs.psl.config.ConfigBundle;
import org.linqs.psl.database.Database;
import org.linqs.psl.database.Partition;
import org.linqs.psl.database.rdbms.RDBMSDataStore;
import org.linqs.psl.model.predicate.StandardPredicate;
import org.linqs.psl.reasoner.inspector.ReasonerInspector;

public abstract class DatabaseReasonerInspector
implements ReasonerInspector {
    public static final String DEFAULT_TRUTH_PARTITION_NAME = "truth";
    private String truthPartitionName = "truth";

    public DatabaseReasonerInspector(ConfigBundle config) {
    }

    protected Database getRandomVariableDatabase() {
        Set<RDBMSDataStore> dataStores = RDBMSDataStore.getOpenDataStores();
        if (dataStores.size() != 1) {
            throw new IllegalStateException("Expected exactly one active datastore, found " + dataStores.size());
        }
        Collection<Database> databases = dataStores.iterator().next().getOpenDatabases();
        if (databases.size() != 1) {
            throw new IllegalStateException("Expected exactly one open database, found " + databases.size());
        }
        return databases.iterator().next();
    }

    protected Database getTruthDatabase(Database rvDatabase) {
        Partition truthPartition = rvDatabase.getDataStore().getPartition(this.truthPartitionName);
        HashSet<StandardPredicate> openPredicates = new HashSet<StandardPredicate>();
        for (StandardPredicate predicate : rvDatabase.getRegisteredPredicates()) {
            if (rvDatabase.isClosed(predicate)) continue;
            openPredicates.add(predicate);
        }
        return rvDatabase.getDataStore().getDatabase(truthPartition, openPredicates, new Partition[0]);
    }
}

