/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.list.UnmodifiableList;
import org.linqs.psl.config.ConfigBundle;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.reasoner.term.Term;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.reasoner.term.WeightedTerm;

public class MemoryTermStore<E extends Term>
implements TermStore<E> {
    public static final String CONFIG_PREFIX = "memorytermstore";
    public static final String INITIAL_SIZE_KEY = "memorytermstore.initialsize";
    public static final int INITIAL_SIZE_DEFAULT = 5000;
    private List<E> store;
    private Map<WeightedGroundRule, List<Integer>> ruleMapping;

    public MemoryTermStore() {
        this(5000);
    }

    public MemoryTermStore(ConfigBundle config) {
        this(config.getInt(INITIAL_SIZE_KEY, 5000));
    }

    public MemoryTermStore(int initialSize) {
        this.store = new ArrayList(initialSize);
        this.ruleMapping = new HashMap<WeightedGroundRule, List<Integer>>(initialSize);
    }

    @Override
    public synchronized void add(GroundRule rule, E term) {
        if (rule instanceof WeightedGroundRule && term instanceof WeightedTerm) {
            if (!this.ruleMapping.containsKey((WeightedGroundRule)rule)) {
                this.ruleMapping.put((WeightedGroundRule)rule, new LinkedList());
            }
            this.ruleMapping.get((WeightedGroundRule)rule).add(new Integer(this.store.size()));
        }
        this.store.add(term);
    }

    @Override
    public void clear() {
        this.store.clear();
        this.ruleMapping.clear();
    }

    @Override
    public void close() {
        this.clear();
        this.store = null;
        this.ruleMapping = null;
    }

    @Override
    public E get(int index) {
        return (E)((Term)this.store.get(index));
    }

    @Override
    public int size() {
        return this.store.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.store.iterator();
    }

    @Override
    public void updateWeight(WeightedGroundRule rule) {
        List<Integer> indexes = this.ruleMapping.get(rule);
        float weight = (float)rule.getWeight();
        for (int i = 0; i < indexes.size(); ++i) {
            ((WeightedTerm)this.store.get(indexes.get(i))).setWeight(weight);
        }
    }

    @Override
    public List<Integer> getTermIndices(WeightedGroundRule rule) {
        return new UnmodifiableList<Integer>(this.ruleMapping.get(rule));
    }
}

