/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.reasoner.term.blocker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.linqs.psl.application.groundrulestore.GroundRuleStore;
import org.linqs.psl.model.atom.RandomVariableAtom;
import org.linqs.psl.model.rule.GroundRule;
import org.linqs.psl.model.rule.WeightedGroundRule;
import org.linqs.psl.reasoner.term.TermStore;
import org.linqs.psl.reasoner.term.blocker.ConstraintBlockerTerm;

public class ConstraintBlockerTermStore
implements TermStore<ConstraintBlockerTerm> {
    private List<ConstraintBlockerTerm> blocks = new ArrayList<ConstraintBlockerTerm>();
    private Map<RandomVariableAtom, Integer> rvMap = new HashMap<RandomVariableAtom, Integer>();
    private GroundRuleStore groundRuleStore = null;

    public void init(GroundRuleStore groundRuleStore, RandomVariableAtom[][] rvBlocks, WeightedGroundRule[][] incidentGRs, boolean[] exactlyOne) {
        assert (rvBlocks.length == incidentGRs.length);
        assert (rvBlocks.length == exactlyOne.length);
        this.groundRuleStore = groundRuleStore;
        for (int i = 0; i < rvBlocks.length; ++i) {
            Integer blockIndex = new Integer(this.blocks.size());
            this.blocks.add(new ConstraintBlockerTerm(rvBlocks[i], incidentGRs[i], exactlyOne[i]));
            for (RandomVariableAtom atom : rvBlocks[i]) {
                this.rvMap.put(atom, blockIndex);
            }
        }
    }

    public GroundRuleStore getGroundRuleStore() {
        return this.groundRuleStore;
    }

    public int getBlockIndex(RandomVariableAtom atom) {
        Integer index = this.rvMap.get(atom);
        if (index == null) {
            return -1;
        }
        return index;
    }

    public void randomlyInitialize() {
        Random rand = new Random();
        for (ConstraintBlockerTerm block : this.blocks) {
            block.randomlyInitialize(rand);
        }
    }

    @Override
    public void add(GroundRule rule, ConstraintBlockerTerm term) {
        throw new UnsupportedOperationException("ConstraintBlockerTermStore needs all ground rules at once, use init().");
    }

    @Override
    public void clear() {
        this.blocks.clear();
        this.rvMap.clear();
        this.groundRuleStore = null;
    }

    @Override
    public void close() {
        this.clear();
        this.blocks = null;
        this.rvMap = null;
    }

    @Override
    public ConstraintBlockerTerm get(int index) {
        return this.blocks.get(index);
    }

    @Override
    public int size() {
        return this.blocks.size();
    }

    @Override
    public void updateWeight(WeightedGroundRule rule) {
    }

    @Override
    public List<Integer> getTermIndices(WeightedGroundRule rule) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<ConstraintBlockerTerm> iterator() {
        return this.blocks.iterator();
    }
}

