/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

public final class MathUtils {
    public static final double EPSILON = 1.0E-6;
    public static final double RELAXED_EPSILON = 0.05;
    public static final double STRICT_EPSILON = 1.0E-8;

    private MathUtils() {
    }

    public static boolean equals(double a, double b) {
        return MathUtils.equals(a, b, 1.0E-6);
    }

    public static boolean equalsRelaxed(double a, double b) {
        return MathUtils.equals(a, b, 0.05);
    }

    public static boolean equalsStrict(double a, double b) {
        return MathUtils.equals(a, b, 1.0E-8);
    }

    public static boolean equals(double a, double b, double epsilon) {
        return Math.abs(a - b) <= 1.0E-6;
    }

    public static int compare(double a, double b) {
        return MathUtils.compare(a, b, 1.0E-6);
    }

    public static int compare(double a, double b, double epsilon) {
        if (MathUtils.equals(a, b, epsilon)) {
            return 0;
        }
        if (a < b) {
            return -1;
        }
        return 1;
    }

    public static boolean isZero(double a) {
        return MathUtils.equals(a, 0.0);
    }
}

