/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.linqs.psl.config.ConfigBundle;

public final class Objects {
    private Objects() {
    }

    public static Object newObject(String className) {
        return Objects.newObject(className, null);
    }

    public static Object newObject(String className, ConfigBundle config) {
        Class<?> classObject = null;
        try {
            classObject = Class.forName(className);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Could not find class: " + className, ex);
        }
        return Objects.newObject(classObject, config);
    }

    public static Object newObject(Class<?> classObject) {
        return Objects.newObject(classObject, null);
    }

    public static Object newObject(Class<?> classObject, ConfigBundle config) {
        Constructor<?> constructor = null;
        boolean useConfig = true;
        try {
            constructor = classObject.getConstructor(ConfigBundle.class);
        }
        catch (NoSuchMethodException ex) {
            useConfig = false;
        }
        if (!useConfig || config == null) {
            try {
                constructor = classObject.getConstructor(new Class[0]);
                useConfig = false;
            }
            catch (NoSuchMethodException ex2) {
                throw new IllegalArgumentException("Could not find a suitable constructor (only ConfigBundle or no parameters) for " + classObject.getName());
            }
        }
        Object rtn = null;
        try {
            rtn = useConfig ? constructor.newInstance(config) : constructor.newInstance(new Object[0]);
        }
        catch (InstantiationException ex) {
            throw new RuntimeException("Unable to instantiate object (" + classObject.getName() + ")", ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException("Insufficient access to constructor for " + classObject.getName(), ex);
        }
        catch (InvocationTargetException ex) {
            throw new RuntimeException("Error thrown while constructing " + classObject.getName(), ex);
        }
        return rtn;
    }
}

