/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Parallel {
    private static final Logger log = LoggerFactory.getLogger(Parallel.class);
    private static boolean initialized = false;
    public static int NUM_THREADS = Runtime.getRuntime().availableProcessors();
    private static BlockingQueue<Worker<?>> workerQueue;
    private static List<Worker<?>> allWorkers;
    private static ExecutorService pool;

    private Parallel() {
    }

    public static synchronized void count(int start, int end, int increment, Worker<Integer> baseWorker) {
        Parallel.initWorkers(baseWorker);
        Parallel.countInternal(start, end, increment);
        Parallel.cleanupWorkers();
    }

    public static void count(int start, int end, Worker<Integer> baseWorker) {
        Parallel.count(start, end, 1, baseWorker);
    }

    public static void count(int end, Worker<Integer> baseWorker) {
        Parallel.count(0, end, 1, baseWorker);
    }

    private static void countInternal(int start, int end, int increment) {
        Worker<?> worker;
        int i;
        for (i = start; i < end; i += increment) {
            worker = null;
            try {
                worker = workerQueue.take();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted waiting for worker (" + i + ").");
            }
            if (worker.getException() != null) {
                throw new RuntimeException("Exception on worker.", worker.getException());
            }
            Worker<?> intWorker = worker;
            intWorker.setWork(i, new Integer(i));
            pool.execute(intWorker);
        }
        for (i = 0; i < NUM_THREADS; ++i) {
            try {
                worker = workerQueue.take();
                if (worker.getException() == null) continue;
                throw new RuntimeException("Exception on worker.", worker.getException());
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted waiting for worker (" + i + ").");
            }
        }
    }

    public static synchronized <T> void foreach(Iterable<T> work, Worker<T> baseWorker) {
        Parallel.initWorkers(baseWorker);
        Parallel.foreachInternal(work);
        Parallel.cleanupWorkers();
    }

    private static <T> void foreachInternal(Iterable<T> work) {
        int count = 0;
        for (T job : work) {
            Worker<?> worker = null;
            try {
                worker = workerQueue.take();
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted waiting for worker (" + count + ").");
            }
            Worker<?> typedWorker = worker;
            typedWorker.setWork(count, job);
            pool.execute(typedWorker);
            ++count;
        }
        for (int i = 0; i < NUM_THREADS; ++i) {
            try {
                workerQueue.take();
                continue;
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted waiting for worker (" + i + ").");
            }
        }
    }

    private static void initPool() {
        if (initialized) {
            return;
        }
        workerQueue = new LinkedBlockingQueue(NUM_THREADS);
        allWorkers = new ArrayList(NUM_THREADS);
        pool = Executors.newFixedThreadPool(NUM_THREADS, new DaemonThreadFactory());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Parallel.shutdown();
            }
        });
        initialized = true;
    }

    private static <T> void initWorkers(Worker<T> baseWorker) {
        Parallel.initPool();
        workerQueue.clear();
        allWorkers.clear();
        for (int i = 0; i < NUM_THREADS; ++i) {
            Worker<T> worker = null;
            worker = i == NUM_THREADS - 1 ? baseWorker : baseWorker.copy();
            worker.init(i);
            allWorkers.add(worker);
            workerQueue.offer(worker);
        }
    }

    private static void cleanupWorkers() {
        for (Worker<?> worker : allWorkers) {
            worker.close();
        }
        allWorkers.clear();
        workerQueue.clear();
    }

    private static void shutdown() {
        Parallel.cleanupWorkers();
        try {
            pool.shutdownNow();
            pool.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        workerQueue = null;
        allWorkers = null;
        pool = null;
    }

    private static void freeWorker(Worker<?> worker) {
        workerQueue.offer(worker);
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private ThreadFactory defaultThreadFactory = Executors.defaultThreadFactory();

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = this.defaultThreadFactory.newThread(r);
            thread.setDaemon(true);
            return thread;
        }
    }

    public static abstract class Worker<T>
    implements Runnable,
    Cloneable {
        protected int id = -1;
        private int index = -1;
        private T item = null;
        private Exception exception = null;

        public void close() {
        }

        public Worker<T> copy() {
            try {
                return (Worker)this.clone();
            }
            catch (CloneNotSupportedException ex) {
                throw new RuntimeException("Either implement copy(), or support clone() for Workers.", ex);
            }
        }

        public void init(int id) {
            this.id = id;
        }

        public void clearException() {
            this.exception = null;
        }

        public Exception getException() {
            return this.exception;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            try {
                if (this.index == -1) {
                    log.warn("Called run() without first calling setWork().");
                    return;
                }
                this.work(this.index, this.item);
            }
            catch (Exception ex) {
                log.warn("Caught exception on worker: {}", (Object)this.id);
                this.exception = ex;
            }
            finally {
                this.index = -1;
                this.item = null;
                Parallel.freeWorker(this);
            }
        }

        public final void setWork(int index, T item) {
            this.index = index;
            this.item = item;
        }

        public abstract void work(int var1, T var2);
    }
}

