/*
 * Decompiled with CFR 0.152.
 */
package org.linqs.psl.util;

import java.util.List;

public final class StringUtils {
    public static final char DEFAULT_DELIM = ',';

    private StringUtils() {
    }

    public static int[] splitInt(String text) {
        return StringUtils.splitInt(text, ',');
    }

    public static int[] splitInt(String text, char delim) {
        return StringUtils.splitInt(text, "" + delim);
    }

    public static int[] splitInt(String text, String delim) {
        String[] parts = text.split(delim);
        int[] ints = new int[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            ints[i] = Integer.parseInt(parts[i]);
        }
        return ints;
    }

    public static double[] splitDouble(String text) {
        return StringUtils.splitDouble(text, ',');
    }

    public static double[] splitDouble(String text, char delim) {
        return StringUtils.splitDouble(text, "" + delim);
    }

    public static double[] splitDouble(String text, String delim) {
        String[] parts = text.split(delim);
        double[] doubles = new double[parts.length];
        for (int i = 0; i < parts.length; ++i) {
            doubles[i] = Double.parseDouble(parts[i]);
        }
        return doubles;
    }

    public static String join(List<?> parts) {
        return StringUtils.join(parts, ',');
    }

    public static String join(List<?> parts, char delim) {
        return StringUtils.join(parts, "" + delim);
    }

    public static String join(List<?> parts, String delim) {
        StringBuilder builder = new StringBuilder(parts.size() * 2 - 1);
        for (int i = 0; i < parts.size(); ++i) {
            builder.append(parts.get(i));
            if (i == parts.size() - 1) continue;
            builder.append(delim);
        }
        return builder.toString();
    }

    public static String join(Object[] parts) {
        return StringUtils.join(parts, ',');
    }

    public static String join(Object[] parts, char delim) {
        return StringUtils.join(parts, "" + delim);
    }

    public static String join(Object[] parts, String delim) {
        StringBuilder builder = new StringBuilder(parts.length * 2 - 1);
        for (int i = 0; i < parts.length; ++i) {
            builder.append(parts[i]);
            if (i == parts.length - 1) continue;
            builder.append(delim);
        }
        return builder.toString();
    }

    public static String join(int[] parts) {
        return StringUtils.join(parts, ',');
    }

    public static String join(int[] parts, char delim) {
        return StringUtils.join(parts, "" + delim);
    }

    public static String join(int[] parts, String delim) {
        StringBuilder builder = new StringBuilder(parts.length * 2 - 1);
        for (int i = 0; i < parts.length; ++i) {
            builder.append(parts[i]);
            if (i == parts.length - 1) continue;
            builder.append(delim);
        }
        return builder.toString();
    }

    public static String join(double[] parts) {
        return StringUtils.join(parts, ',');
    }

    public static String join(double[] parts, char delim) {
        return StringUtils.join(parts, "" + delim);
    }

    public static String join(double[] parts, String delim) {
        StringBuilder builder = new StringBuilder(parts.length * 2 - 1);
        for (int i = 0; i < parts.length; ++i) {
            builder.append(parts[i]);
            if (i == parts.length - 1) continue;
            builder.append(delim);
        }
        return builder.toString();
    }

    public static String repeat(String text, int times) {
        return StringUtils.repeat(text, "", times);
    }

    public static String repeat(String text, String delim, int times) {
        if (times < 0) {
            throw new IllegalArgumentException("Cannot repeat a string negative times.");
        }
        if (times == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(times * 2);
        for (int i = 0; i < times; ++i) {
            builder.append(text);
            if (i == times - 1) continue;
            builder.append(delim);
        }
        return builder.toString();
    }
}

