__provinces: list[str] = ['直辖市', '特别行政区', '河北省', '山西省',
                          '内蒙古自治区', '辽宁省', '吉林省', '黑龙江省',
                          '江苏省', '浙江省', '安徽省', '福建省',
                          '江西省', '山东省', '河南省', '湖北省',
                          '湖南省', '广东省', '广西壮族自治区', '海南省',
                          '四川省', '贵州省', '云南省', '陕西省',
                          '甘肃省', '青海省', '西藏自治区', '宁夏回族自治区',
                          '新疆维吾尔自治区', '台湾省']

__cities: list[dict[str, str]] = [{'name': '直辖市',
                                   'cities': [
                                       '北京市',
                                       '上海市',
                                       '天津市',
                                       '重庆市']
                                   },
                                  {
                                      'name': '特别行政区',
                                      'cities': [
                                          '香港特别行政区',
                                          '澳门特别行政区']
                                  },
                                  {
                                      'name': '河北省',
                                      'cities': [
                                          '石家庄市',
                                          '唐山市',
                                          '秦皇岛市',
                                          '邯郸市',
                                          '邢台市',
                                          '保定市',
                                          '张家口市',
                                          '承德市',
                                          '沧州市',
                                          '廊坊市',
                                          '衡水市',
                                          '辛集市',
                                          '晋州市',
                                          '新乐市',
                                          '遵化市',
                                          '迁安市',
                                          '武安市',
                                          '南宫市',
                                          '沙河市',
                                          '涿州市',
                                          '定州市',
                                          '安国市',
                                          '高碑店市',
                                          '平泉市',
                                          '泊头市',
                                          '任丘市',
                                          '黄骅市',
                                          '河间市',
                                          '霸州市',
                                          '三河市',
                                          '深州市']
                                  },
                                  {
                                      'name': '山西省',
                                      'cities': [
                                          '太原市',
                                          '大同市',
                                          '阳泉市',
                                          '长治市',
                                          '晋城市',
                                          '朔州市',
                                          '晋中市',
                                          '运城市',
                                          '忻州市',
                                          '临汾市',
                                          '吕梁市',
                                          '古交市',
                                          '高平市',
                                          '介休市',
                                          '永济市',
                                          '河津市',
                                          '原平市',
                                          '侯马市',
                                          '霍州市',
                                          '孝义市',
                                          '汾阳市',
                                          '怀仁市']
                                  },
                                  {
                                      'name': '内蒙古自治区',
                                      'cities': [
                                          '呼和浩特市',
                                          '包头市',
                                          '乌海市',
                                          '赤峰市',
                                          '通辽市',
                                          '鄂尔多斯市',
                                          '呼伦贝尔市',
                                          '巴彦淖尔市',
                                          '乌兰察布市',
                                          '霍林郭勒市',
                                          '满洲里市',
                                          '牙克石市',
                                          '扎兰屯市',
                                          '额尔古纳市',
                                          '根河市',
                                          '丰镇市',
                                          '乌兰浩特市',
                                          '阿尔山市',
                                          '二连浩特市',
                                          '锡林浩特市']
                                  },
                                  {
                                      'name': '辽宁省',
                                      'cities': [
                                          '沈阳市',
                                          '大连市',
                                          '鞍山市',
                                          '抚顺市',
                                          '本溪市',
                                          '丹东市',
                                          '锦州市',
                                          '营口市',
                                          '阜新市',
                                          '辽阳市',
                                          '盘锦市',
                                          '铁岭市',
                                          '朝阳市',
                                          '葫芦岛市',
                                          '新民市',
                                          '瓦房店市',
                                          '庄河市',
                                          '海城市',
                                          '东港市',
                                          '凤城市',
                                          '凌海市',
                                          '北镇市',
                                          '盖州市',
                                          '大石桥市',
                                          '灯塔市',
                                          '调兵山市',
                                          '开原市',
                                          '北票市',
                                          '凌源市',
                                          '兴城市']
                                  },
                                  {
                                      'name': '吉林省',
                                      'cities': [
                                          '长春市',
                                          '吉林市',
                                          '四平市',
                                          '辽源市',
                                          '通化市',
                                          '白山市',
                                          '松原市',
                                          '白城市',
                                          '榆树市',
                                          '德惠市',
                                          '蛟河市',
                                          '桦甸市',
                                          '舒兰市',
                                          '磐石市',
                                          '公主岭市',
                                          '双辽市',
                                          '梅河口市',
                                          '集安市',
                                          '洮南市',
                                          '大安市',
                                          '临江市',
                                          '延吉市',
                                          '图们市',
                                          '敦化市',
                                          '珲春市',
                                          '龙井市',
                                          '和龙市',
                                          '扶余市']
                                  },
                                  {
                                      'name': '黑龙江省',
                                      'cities': [
                                          '哈尔滨市',
                                          '齐齐哈尔市',
                                          '黑河市',
                                          '大庆市',
                                          '伊春市',
                                          '鹤岗市',
                                          '佳木斯市',
                                          '双鸭山市',
                                          '七台河市',
                                          '鸡西市',
                                          '牡丹江市',
                                          '绥化市',
                                          '尚志市',
                                          '五常市',
                                          '讷河市',
                                          '北安市',
                                          '五大连池市',
                                          '嫩江市',
                                          '铁力市',
                                          '同江市',
                                          '富锦市',
                                          '虎林市',
                                          '密山市',
                                          '绥芬河市',
                                          '海林市',
                                          '宁安市',
                                          '安达市',
                                          '肇东市',
                                          '海伦市',
                                          '穆棱市',
                                          '东宁市',
                                          '抚远市',
                                          '漠河市']
                                  },
                                  {
                                      'name': '江苏省',
                                      'cities': [
                                          '南京市',
                                          '徐州市',
                                          '连云港市',
                                          '宿迁市',
                                          '淮安市',
                                          '盐城市',
                                          '扬州市',
                                          '泰州市',
                                          '南通市',
                                          '镇江市',
                                          '常州市',
                                          '无锡市',
                                          '苏州市',
                                          '常熟市',
                                          '张家港市',
                                          '太仓市',
                                          '昆山市',
                                          '江阴市',
                                          '宜兴市',
                                          '溧阳市',
                                          '扬中市',
                                          '句容市',
                                          '丹阳市',
                                          '如皋市',
                                          '启东市',
                                          '海安市',
                                          '高邮市',
                                          '仪征市',
                                          '兴化市',
                                          '泰兴市',
                                          '靖江市',
                                          '东台市',
                                          '邳州市',
                                          '新沂市']
                                  },
                                  {
                                      'name': '浙江省',
                                      'cities': [
                                          '杭州市',
                                          '宁波市',
                                          '湖州市',
                                          '嘉兴市',
                                          '舟山市',
                                          '绍兴市',
                                          '衢州市',
                                          '金华市',
                                          '台州市',
                                          '温州市',
                                          '丽水市',
                                          '建德市',
                                          '慈溪市',
                                          '余姚市',
                                          '平湖市',
                                          '海宁市',
                                          '桐乡市',
                                          '诸暨市',
                                          '嵊州市',
                                          '江山市',
                                          '兰溪市',
                                          '永康市',
                                          '义乌市',
                                          '东阳市',
                                          '临海市',
                                          '温岭市',
                                          '瑞安市',
                                          '乐清市',
                                          '龙港市',
                                          '龙泉市',
                                          '玉环市']
                                  },
                                  {
                                      'name': '安徽省',
                                      'cities': [
                                          '合肥市',
                                          '芜湖市',
                                          '蚌埠市',
                                          '淮南市',
                                          '马鞍山市',
                                          '淮北市',
                                          '铜陵市',
                                          '安庆市',
                                          '黄山市',
                                          '滁州市',
                                          '阜阳市',
                                          '宿州市',
                                          '六安市',
                                          '亳州市',
                                          '池州市',
                                          '宣城市',
                                          '巢湖市',
                                          '桐城市',
                                          '天长市',
                                          '明光市',
                                          '界首市',
                                          '宁国市',
                                          '广德市',
                                          '潜山市',
                                          '无为市']
                                  },
                                  {
                                      'name': '福建省',
                                      'cities': [
                                          '厦门市',
                                          '福州市',
                                          '南平市',
                                          '三明市',
                                          '莆田市',
                                          '泉州市',
                                          '漳州市',
                                          '龙岩市',
                                          '宁德市',
                                          '福清市',
                                          '邵武市',
                                          '武夷山市',
                                          '建瓯市',
                                          '永安市',
                                          '石狮市',
                                          '晋江市',
                                          '南安市',
                                          '龙海市',
                                          '漳平市',
                                          '福安市',
                                          '福鼎市']
                                  },
                                  {
                                      'name': '江西省',
                                      'cities': [
                                          '南昌市',
                                          '九江市',
                                          '景德镇市',
                                          '鹰潭市',
                                          '新余市',
                                          '萍乡市',
                                          '赣州市',
                                          '上饶市',
                                          '抚州市',
                                          '宜春市',
                                          '吉安市',
                                          '瑞昌市',
                                          '共青城市',
                                          '庐山市',
                                          '乐平市',
                                          '瑞金市',
                                          '德兴市',
                                          '丰城市',
                                          '樟树市',
                                          '高安市',
                                          '井冈山市',
                                          '贵溪市']
                                  },
                                  {
                                      'name': '山东省',
                                      'cities': [
                                          '济南市',
                                          '青岛市',
                                          '聊城市',
                                          '德州市',
                                          '东营市',
                                          '淄博市',
                                          '潍坊市',
                                          '烟台市',
                                          '威海市',
                                          '日照市',
                                          '临沂市',
                                          '枣庄市',
                                          '济宁市',
                                          '泰安市',
                                          '滨州市',
                                          '菏泽市',
                                          '胶州市',
                                          '平度市',
                                          '莱西市',
                                          '临清市',
                                          '乐陵市',
                                          '禹城市',
                                          '安丘市',
                                          '昌邑市',
                                          '高密市',
                                          '青州市',
                                          '诸城市',
                                          '寿光市',
                                          '栖霞市',
                                          '海阳市',
                                          '龙口市',
                                          '莱阳市',
                                          '莱州市',
                                          '蓬莱市',
                                          '招远市',
                                          '荣成市',
                                          '乳山市',
                                          '滕州市',
                                          '曲阜市',
                                          '邹城市',
                                          '新泰市',
                                          '肥城市',
                                          '邹平市']
                                  },
                                  {
                                      'name': '河南省',
                                      'cities': [
                                          '郑州市',
                                          '开封市',
                                          '洛阳市',
                                          '平顶山市',
                                          '安阳市',
                                          '鹤壁市',
                                          '新乡市',
                                          '焦作市',
                                          '濮阳市',
                                          '许昌市',
                                          '漯河市',
                                          '三门峡市',
                                          '南阳市',
                                          '商丘市',
                                          '周口市',
                                          '驻马店市',
                                          '信阳市',
                                          '荥阳市',
                                          '新郑市',
                                          '登封市',
                                          '新密市',
                                          '偃师市',
                                          '孟州市',
                                          '沁阳市',
                                          '卫辉市',
                                          '辉县市',
                                          '长垣市',
                                          '林州市',
                                          '禹州市',
                                          '长葛市',
                                          '舞钢市',
                                          '义马市',
                                          '灵宝市',
                                          '项城市',
                                          '巩义市',
                                          '邓州市',
                                          '永城市',
                                          '汝州市',
                                          '济源市']
                                  },
                                  {
                                      'name': '湖北省',
                                      'cities': [
                                          '武汉市',
                                          '十堰市',
                                          '襄阳市',
                                          '荆门市',
                                          '孝感市',
                                          '黄冈市',
                                          '鄂州市',
                                          '黄石市',
                                          '咸宁市',
                                          '荆州市',
                                          '宜昌市',
                                          '随州市',
                                          '丹江口市',
                                          '老河口市',
                                          '枣阳市',
                                          '宜城市',
                                          '钟祥市',
                                          '京山市',
                                          '汉川市',
                                          '应城市',
                                          '安陆市',
                                          '广水市',
                                          '麻城市',
                                          '武穴市',
                                          '大冶市',
                                          '赤壁市',
                                          '石首市',
                                          '洪湖市',
                                          '松滋市',
                                          '宜都市',
                                          '枝江市',
                                          '当阳市',
                                          '恩施市',
                                          '利川市',
                                          '仙桃市',
                                          '天门市',
                                          '潜江市']
                                  },
                                  {
                                      'name': '湖南省',
                                      'cities': [
                                          '长沙市',
                                          '衡阳市',
                                          '张家界市',
                                          '常德市',
                                          '益阳市',
                                          '岳阳市',
                                          '株洲市',
                                          '湘潭市',
                                          '郴州市',
                                          '永州市',
                                          '邵阳市',
                                          '怀化市',
                                          '娄底市',
                                          '耒阳市',
                                          '常宁市',
                                          '浏阳市',
                                          '津市市',
                                          '沅江市',
                                          '汨罗市',
                                          '临湘市',
                                          '醴陵市',
                                          '湘乡市',
                                          '韶山市',
                                          '资兴市',
                                          '武冈市',
                                          '邵东市',
                                          '洪江市',
                                          '冷水江市',
                                          '涟源市',
                                          '吉首市',
                                          '宁乡市']
                                  },
                                  {
                                      'name': '广东省',
                                      'cities': [
                                          '广州市',
                                          '深圳市',
                                          '清远市',
                                          '韶关市',
                                          '河源市',
                                          '梅州市',
                                          '潮州市',
                                          '汕头市',
                                          '揭阳市',
                                          '汕尾市',
                                          '惠州市',
                                          '东莞市',
                                          '珠海市',
                                          '中山市',
                                          '江门市',
                                          '佛山市',
                                          '肇庆市',
                                          '云浮市',
                                          '阳江市',
                                          '茂名市',
                                          '湛江市',
                                          '英德市',
                                          '连州市',
                                          '乐昌市',
                                          '南雄市',
                                          '兴宁市',
                                          '普宁市',
                                          '陆丰市',
                                          '恩平市',
                                          '台山市',
                                          '开平市',
                                          '鹤山市',
                                          '四会市',
                                          '罗定市',
                                          '阳春市',
                                          '化州市',
                                          '信宜市',
                                          '高州市',
                                          '吴川市',
                                          '廉江市',
                                          '雷州市']
                                  },
                                  {
                                      'name': '广西壮族自治区',
                                      'cities': ['南宁市',
                                                 '桂林市',
                                                 '柳州市',
                                                 '梧州市',
                                                 '贵港市',
                                                 '玉林市',
                                                 '钦州市',
                                                 '北海市',
                                                 '防城港市',
                                                 '崇左市',
                                                 '百色市',
                                                 '河池市',
                                                 '来宾市',
                                                 '贺州市',
                                                 '岑溪市',
                                                 '桂平市',
                                                 '北流市',
                                                 '东兴市',
                                                 '凭祥市',
                                                 '合山市',
                                                 '靖西市',
                                                 '平果市',
                                                 '荔浦市']
                                  },
                                  {
                                      'name': '海南省',
                                      'cities': ['海口市',
                                                 '三亚市',
                                                 '三沙市',
                                                 '儋州市',
                                                 '文昌市',
                                                 '琼海市',
                                                 '万宁市',
                                                 '东方市',
                                                 '五指山市']
                                  },
                                  {
                                      'name': '四川省',
                                      'cities': ['成都市',
                                                 '广元市',
                                                 '绵阳市',
                                                 '德阳市',
                                                 '南充市',
                                                 '广安市',
                                                 '遂宁市',
                                                 '内江市',
                                                 '乐山市',
                                                 '自贡市',
                                                 '泸州市',
                                                 '宜宾市',
                                                 '攀枝花市',
                                                 '巴中市',
                                                 '达州市',
                                                 '资阳市',
                                                 '眉山市',
                                                 '雅安市',
                                                 '崇州市',
                                                 '邛崃市',
                                                 '都江堰市',
                                                 '彭州市',
                                                 '江油市',
                                                 '什邡市',
                                                 '广汉市',
                                                 '绵竹市',
                                                 '阆中市',
                                                 '华蓥市',
                                                 '峨眉山市',
                                                 '万源市',
                                                 '简阳市',
                                                 '西昌市',
                                                 '康定市',
                                                 '马尔康市',
                                                 '隆昌市',
                                                 '射洪市',
                                                 '会理市']
                                  },
                                  {
                                      'name': '贵州省',
                                      'cities': ['贵阳市',
                                                 '六盘水市',
                                                 '遵义市',
                                                 '安顺市',
                                                 '毕节市',
                                                 '铜仁市',
                                                 '清镇市',
                                                 '赤水市',
                                                 '仁怀市',
                                                 '凯里市',
                                                 '都匀市',
                                                 '兴义市',
                                                 '福泉市',
                                                 '盘州市',
                                                 '兴仁市']
                                  },
                                  {
                                      'name': '云南省',
                                      'cities': ['昆明市',
                                                 '曲靖市',
                                                 '玉溪市',
                                                 '丽江市',
                                                 '昭通市',
                                                 '普洱市',
                                                 '临沧市',
                                                 '保山市',
                                                 '安宁市',
                                                 '宣威市',
                                                 '芒市',
                                                 '瑞丽市',
                                                 '大理市',
                                                 '楚雄市',
                                                 '个旧市',
                                                 '开远市',
                                                 '蒙自市',
                                                 '弥勒市',
                                                 '景洪市',
                                                 '文山市',
                                                 '香格里拉市',
                                                 '腾冲市',
                                                 '水富市',
                                                 '澄江市',
                                                 '泸水市']
                                  },
                                  {
                                      'name': '陕西省',
                                      'cities': ['西安市',
                                                 '延安市',
                                                 '铜川市',
                                                 '渭南市',
                                                 '咸阳市',
                                                 '宝鸡市',
                                                 '汉中市',
                                                 '榆林市',
                                                 '商洛市',
                                                 '安康市',
                                                 '韩城市',
                                                 '华阴市',
                                                 '兴平市',
                                                 '彬州市',
                                                 '神木市',
                                                 '子长市']
                                  },
                                  {
                                      'name': '甘肃省',
                                      'cities': ['兰州市',
                                                 '嘉峪关市',
                                                 '金昌市',
                                                 '白银市',
                                                 '天水市',
                                                 '酒泉市',
                                                 '张掖市',
                                                 '武威市',
                                                 '庆阳市',
                                                 '平凉市',
                                                 '定西市',
                                                 '陇南市',
                                                 '玉门市',
                                                 '敦煌市',
                                                 '临夏市',
                                                 '合作市',
                                                 '华亭市']
                                  },
                                  {
                                      'name': '青海省',
                                      'cities': ['西宁市',
                                                 '海东市',
                                                 '格尔木市',
                                                 '德令哈市',
                                                 '玉树市',
                                                 '茫崖市']
                                  },
                                  {
                                      'name': '西藏自治区',
                                      'cities': ['拉萨市',
                                                 '日喀则市',
                                                 '昌都市',
                                                 '林芝市',
                                                 '山南市',
                                                 '那曲市',
                                                 '阿里市']
                                  },
                                  {
                                      'name': '宁夏回族自治区',
                                      'cities': ['银川市',
                                                 '石嘴山市',
                                                 '吴忠市',
                                                 '中卫市',
                                                 '固原市',
                                                 '灵武市',
                                                 '青铜峡市']
                                  },
                                  {
                                      'name': '新疆维吾尔自治区',
                                      'cities': ['乌鲁木齐市',
                                                 '克拉玛依市',
                                                 '吐鲁番市',
                                                 '哈密市',
                                                 '喀什市',
                                                 '阿克苏市',
                                                 '库车市',
                                                 '和田市',
                                                 '阿图什市',
                                                 '阿拉山口市',
                                                 '博乐市',
                                                 '昌吉市',
                                                 '阜康市',
                                                 '库尔勒市',
                                                 '伊宁市',
                                                 '奎屯市',
                                                 '塔城市',
                                                 '乌苏市',
                                                 '阿勒泰市',
                                                 '霍尔果斯市',
                                                 '石河子市',
                                                 '阿拉尔市',
                                                 '图木舒克市',
                                                 '五家渠市',
                                                 '北屯市',
                                                 '铁门关市',
                                                 '双河市',
                                                 '可克达拉市',
                                                 '昆玉市',
                                                 '胡杨河市']
                                  },
                                  {
                                      'name': '台湾省',
                                      'cities': [
                                          '台北市',
                                          '新北市',
                                          '桃园市',
                                          '台中市',
                                          '台南市',
                                          '高雄市',
                                          '基隆市',
                                          '新竹市',
                                          '嘉义市']
                                  }]


def get_provinces():
    return __provinces


def get_cities(name: str):
    if not isinstance(name, str):
        raise TypeError('the argument(name) must be a string')
    for city in __cities:
        if city['name'] == name:
            return city
    raise ValueError('the argument(name) does not exist in the cities')


def get_all_cities():
    return __cities
